function varargout = laboratorium(varargin)
%LABORATORIUM M-file for laboratorium.fig
%      LABORATORIUM, by itself, creates a new LABORATORIUM or raises the existing
%      singleton*.
%
%      Copyright 2006 Lukasz Kruk
%
%      H = LABORATORIUM returns the handle to a new LABORATORIUM or the handle to
%      the existing singleton*.
%
%      LABORATORIUM('Property','Value',...) creates a new LABORATORIUM using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to laboratorium_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      LABORATORIUM('CALLBACK') and LABORATORIUM('CALLBACK',hObject,...) call the
%      local function named CALLBACK in LABORATORIUM.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help laboratorium

% Last Modified by GUIDE v2.5 28-May-2014 11:33:19

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @laboratorium_OpeningFcn, ...
    'gui_OutputFcn',  @laboratorium_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before laboratorium is made visible.
function laboratorium_OpeningFcn(hObject, eventdata, handles, varargin)

% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for laboratorium
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);


% UIWAIT makes laboratorium wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = laboratorium_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


%--------------------------------------------------------------------------
function a0_Callback(hObject, eventdata, handles)
% hObject    handle to a0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of a0 as text
%        str2double(get(hObject,'String')) returns contents of a0 as a double
a0 = str2double(get(hObject, 'String'));
data = getappdata(gcbf,'metricdata');
if (isnan(a0)||(a0>2)||(a0<-2)||(a0<data.a1))       %sprawdzanie poprawnosci a0
    set(hObject,'String',0.5);
    errordlg('Nalezy wprowadzic liczbe z przedzialu [-2 2],                         amplituda a1 powinna byc wieksza od a0','Zle');
end

if (isnan(a0)||(a0>2)||(a0<-2)||(a0<data.a1))
    data.a0=0.5;
else
    data.a0 = a0;
end
%-rysowanie pkt konstelacji
cla;
plot(data.a0,data.a0,'b.','Markersize',15,'HitTest','off');
plot(data.a1,data.a1,'r.','Markersize',15,'HitTest','off');
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function a0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to a0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.a0 = 0.5;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function a1_Callback(hObject, eventdata, handles)
% hObject    handle to a1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of a1 as text
%        str2double(get(hObject,'String')) returns contents of a1 as a double
a1 = str2double(get(hObject, 'String'));
data = getappdata(gcbf,'metricdata');
if (isnan(a1)||(a1>2)||(a1<-2)||(a1>data.a0))
    set(hObject,'String',-0.5);
    errordlg('Nalezy wprowadzic liczbe z przedzialu [-2 2],                         amplituda a1 powinna byc wieksza od a0','Zle');
end

if (isnan(a1)||(a1>2)||(a1<-2)||(a1>data.a0))
    data.a1=-0.5;
else
    data.a1 = a1;
end
%-rysowanie pkt konstelacji
cla;
plot(data.a0,data.a0,'b.','Markersize',15,'HitTest','off');
plot(data.a1,data.a1,'r.','Markersize',15,'HitTest','off');
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function a1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to a1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.a1 = -0.5;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function p0_Callback(hObject, eventdata, handles)
% hObject    handle to p0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of p0 as text
%        str2double(get(hObject,'String')) returns contents of p0 as a double
p0 = str2double(get(hObject, 'String'));
if (isnan(p0)||(p0>1)||(p0<0))
    set(hObject,'String',0.5);
    errordlg('Nalezy wprowadzic liczbe z zakresu [0,1]','Zle');
end
data = getappdata(gcbf,'metricdata');
if (isnan(p0))
    data.p0=0.5;
else
    data.p0 = p0;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function p0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to p0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.p0 = 0.5;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function snr_Callback(hObject, eventdata, handles)
% hObject    handle to snr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of snr as text
%        str2double(get(hObject,'String')) returns contents of snr as a double
snr = str2double(get(hObject, 'String'));
if isnan(snr)
    set(hObject,'String',6);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end

data = getappdata(gcbf,'metricdata');
if isnan(snr)
    data.snr=6;
else
    data.snr = snr;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function snr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to snr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

data = getappdata(gcbf,'metricdata');
data.snr = 6;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function msglen_Callback(hObject, eventdata, handles)
% hObject    handle to msglen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of msglen as text
%        str2double(get(hObject,'String')) returns contents of msglen as a double
msglen = str2double(get(hObject, 'String'));
if (isnan(msglen)||(msglen>1000000))
    set(hObject,'String',25000);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end

data = getappdata(gcbf,'metricdata');
if (isnan(msglen)||(msglen>1000000))
    data.msglen=25000;
else
    data.msglen = msglen;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function msglen_CreateFcn(hObject, eventdata, handles)
% hObject    handle to msglen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.msglen = 25000;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes on button press in symulacjabutt.
function symulacjabutt_Callback(hObject, eventdata, handles)
% hObject    handle to symulacjabutt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%handles
data = getappdata(gcbf,'metricdata');
data.piersym = 1;
if get(handles.polski,'Value')==1
    set(handles.informacja,'String','Prosze czekac...');
else
   set(handles.informacja,'String','Please, wait...'); 
end
set(handles.konstelacja,'ButtonDownFcn','laboratorium(''konstelacja_cw1mouse'',gcbo,[],guidata(gcbo))');
set(handles.wynPe,'String','');
set(handles.wynP01,'String','');
set(handles.wynP10,'String','');
set(handles.P01,'String','');
set(handles.P10,'String','');
set(handles.wynentropia,'String','');
snr = data.snr;                 %SNR
M = 2;                          %romiar alfabetu
a0 = data.a0;                   %amplituda dla sygnalu reprezentujacego 0
a1 = data.a1;                   %amplituda dla sygnalu reprezentujacego 1
p0 = data.p0;                   %prawdopodobienstwo pojawienia 0
p1 = 1 - p0;                    %prawdopodobienstwo pojawienia 1
msglen = data.msglen;           %dlugosc informacji
H = p0*log2(1/p0)+p1*log2(1/p1);

s=a0^2*p0+a1^2*p1;              %moc sygnalu
n = s/(10^(snr/10));            %moc szumu

msg = randsrc( msglen, 1, [a0 a1; p0 p1]);  %generowanie wiadomosci

msg0=0;                         %liczba nadanych syg o a0
msg1=0;                         %liczba nadanych syg o a1
for i = 1:size(msg)
    if (msg(i) == a0)
        msg0=msg0+1;
    else
        msg1=msg1+1;
    end
end

rayleigh = get(handles.rayleigh,'Value');
if rayleigh == 0
    sentmsg=complex(msg,msg);                   %wyslana wiadomosc, z kazdego impulsu przesylamy 2 probki
else
    temp = ones(msglen,1);
    for i=1:size(msg)
        temp(i)=raylrnd(1)*msg(i);
    end
    sentmsg=complex(temp,temp);
end

%sygnal przesylamy w postaci
%zespolonej
recmsg=sentmsg+wgn2(size(sentmsg,1), size(sentmsg,2), n, 'linear', 'complex');    %dodanie szumu bialego
hold off;
%--tworzenie tablic z odebranymi sygnalami a0 i a1
recmsga0=zeros(msg0,1);
recmsga1=zeros(msg1,1);
recmsga0=complex(recmsga0,0);
recmsga1=complex(recmsga1,0);
k=1;
n=1;
for i=1:size(msg,1)
    if msg(i)==a0
        recmsga0(k)=recmsg(i);
        k=k+1;
    else
        recmsga1(n)=recmsg(i);
        n=n+1;
    end
end
xmax = max(real(recmsg));
xmin = min(real(recmsg));
ymax = max(imag(recmsg));
ymin = min(imag(recmsg));
%ustalanie zakresow osi
limx = 0;
limy = 0;
if abs(xmax)>abs(xmin)
    limx = abs(xmax);
else
    limx = abs(xmin);
end

if abs(ymax)>abs(ymin)
    limy = abs(ymax);
else
    limy = abs(ymin);
end
hold on;
cla;
%-tu wprowadzalem poprawki
msg0norm=fix(msg0/10);
msg1norm=fix(msg1/10);
x=0;
od0=1;
do0=0;
od1=1;
do1=0;
h = waitbar(x,'Prosze czekac');
for i=1:10
    x=x+0.1;
    waitbar(x)
    do1=i*msg1norm;
    do0=i*msg0norm;
    plot(handles.konstelacja,real(recmsga0(od0:1:do0)),imag(recmsga0(od0:1:do0)),'b.','HitTest','off','MarkerSize',1); %------RYSUJEMY KONSTELACJE A0 i A1 sprawdz to!!!!
    plot(handles.konstelacja,real(recmsga1(od1:1:do1)),imag(recmsga1(od1:1:do1)),'r.','HitTest','off','MarkerSize',1);
    od1=do1+1;
    od0=do0+1;
end
close(h);
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
wynp0 = msg1/msglen;    %stosunek liczby nadanych s0 do wszystkich nadanych sygnalow
wynp1 = msg0/msglen;    %stosunek liczby nadanych s1 do wszystkich nadanych sygnalow

set(handles.wynp0,'String',wynp0);
set(handles.wynp1,'String',wynp1);
set(handles.wynentropia,'String',H);
if get(handles.polski,'Value')==1
    set(handles.informacja,'String','Klikajac mysza na obrszarze wykresu, wybierz 2 punkty, przez ktore przejdzie prosta decyzyjna');
else
    set(handles.informacja,'String','Select two points over the axes');  
end

data = getappdata(gcbf,'metricdata');
data.limx=limx;
data.limy=limy;
data.recmsg = recmsg;
data.msg = msg;
data.msg1 = msg1;
data.msg0 = msg0;
data.recmsga0=recmsga0;
data.recmsga1=recmsga1;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes on button press in koniecbutt.
function koniecbutt_Callback(hObject, eventdata, handles)
% hObject    handle to koniecbutt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function konstelacja_CreateFcn(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate konstelacja
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function axes3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes3
% --------------------------------------------------------------------
function plik_Callback(hObject, eventdata, handles)
% hObject    handle to plik (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% --------------------------------------------------------------------
%MIANOWANIA I USTAWIANIE WYGLADU POSZCZEGOLNYCH CZESCI CWICZENIA
function czesc1_Callback(hObject, eventdata, handles)
% hObject    handle to czesc1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
data.piersym=0;
axes(handles.bladkata);
cla;
axes(handles.konstelacja);
cla;
hold on;
if (isnan(data.a0))||(isnan(data.a1))
    plot(0.5,0.5,'b.','Markersize',15,'HitTest','off');
    plot(-0.5,-0.5,'r.','Markersize',15,'HitTest','off');
else
    plot(data.a0,data.a0,'b.','Markersize',15,'HitTest','off');
    plot(data.a1,data.a1,'r.','Markersize',15,'HitTest','off');
end
if get(handles.polski,'Value')==1
    set(handles.informacja,'String','Ustaw parametry symulacji a nastepnie klikajac przycisk "SYMULACJA", rozpocznij ja.');
else
    set(handles.informacja,'String','Set parameters and press "SIMULATION"');
end
   

set(handles.save,'Enable','off');
set(handles.open,'Enable','off');
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
set(handles.wynp0,'String','');
set(handles.wynp1,'String','');
set(handles.wynPe,'String','');
set(handles.wynP01,'String','');
set(handles.wynP10,'String','');
set(handles.P01,'String','');
set(handles.P10,'String','');
data.cwiczenie=1;
data.ktest=0;
setappdata(gcbf,'metricdata',data);
set(handles.konstelacja,'ButtonDownFcn','laboratorium(''cwiczenie_Callback'',gcbo,[],guidata(gcbo))');
set(handles.figure1,'WindowButtonMotionFcn','laboratorium(''konstelacja_cw1motion'',gcbo,[],guidata(gcbo))');
set(handles.konstelacja,'Visible','on');
set(handles.panelvol1,'Visible','on');
set(handles.panelvol2,'Visible','off');
set(handles.panelvol3,'Visible','off');
% -------------------------------------------------------------------------
function czesc2_Callback(hObject, eventdata, handles)
% hObject    handle to czesc2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
axes(handles.bladkata);
cla;
axes(handles.konstelacja);
set(handles.save,'Enable','on');
set(handles.open,'Enable','on');
set(handles.konstelacja,'Visible','on');
data = getappdata(gcbf,'metricdata');
set(handles.text34,'String','');
data.cwiczenie=2;
data.ktest=0;
setappdata(gcbf,'metricdata',data);
set(handles.konstelacja,'ButtonDownFcn','laboratorium(''konstelacja_cw2mouseAxes'',gcbo,[],guidata(gcbo))');
set(handles.figure1,'WindowButtonMotionFcn','laboratorium(''konstelacja_cw2motion'',gcbo,[],guidata(gcbo))');
set(handles.popupmenu2,'Value',1);
popupmenu2_Callback(handles.popupmenu2, eventdata, handles);
cla;
radiobutton19_Callback(hObject, eventdata, handles);
set(handles.panelvol1,'Visible','off');
set(handles.panelvol2,'Visible','on');
set(handles.panelvol3,'Visible','off');
% -------------------------------------------------------------------------
function czesc3_Callback(hObject, eventdata, handles)
% hObject    handle to czesc3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
axes(handles.bladkata);
cla;
axes(handles.konstelacja);
cla;
set(handles.pushbutton9,'Enable','off');
set(handles.save,'Enable','off');
set(handles.open,'Enable','off');
set(handles.konstelacja,'Visible','on');
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
set(handles.bladkata,'XTick',0,'YTick',0,'XLim',[-1 1],'YLim',[0 1]);
data = getappdata(gcbf,'metricdata');
data.cwiczenie=3;
set(handles.konstelacja,'ButtonDownFcn','laboratorium(''konstelacja_cw3mouseAxes'',gcbo,[],guidata(gcbo))');
setappdata(gcbf,'metricdata',data);
cla;
set(handles.panelvol1,'Visible','off');
set(handles.panelvol2,'Visible','off');
set(handles.panelvol3,'Visible','on');
% -------------------------------------------------------------------------
function cwiczenie_Callback(hObject, eventdata, handles)
% hObject    handle to cwiczenie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%--------------------------------------------------------------------------
% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = get(hObject,'Value');
switch val
    case 1
        cla;
        set(handles.uipanel15,'Visible','on');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','off');
        set(handles.radiobutton19,'Value',1);
        radiobutton19_Callback(hObject, eventdata, handles);
    case 2
        cla;
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','on');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','off');
        set(handles.radiobutton21,'Value',1);
        radiobutton21_Callback(hObject, eventdata, handles);
    case 3
        cla;
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','on');
        set(handles.uipanel17,'Visible','off');
        set(handles.radiobutton13,'Value',1);
        radiobutton13_Callback(hObject, eventdata, handles);
    case 4
        cla;
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','on');
        set(handles.radiobutton23,'Value',1);
        radiobutton23_Callback(hObject, eventdata, handles);
end
% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%--------------------------------------------------------------------------
function konstelacja_cw1motion(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
x=get(gca,'CurrentPoint');
if data.ktest==1
    p1x=data.kp1x;
    p1y=data.kp1y;
    a=[-2 2];
    if x(1)~=p1x
        b =((x(3)-p1y)/(x(1)-p1x))*(a-p1x)+p1y;

        if ishandle(data.kline)==1
            set(data.kline, 'XData', a, 'YData', b, 'Color', 'y');

        else
            hold on;

            data.kline = plot(a,b,'y','HitTest','off');


        end
    end
else
end
set(handles.text25,'String',x(1));
set(handles.text26,'String',x(3));
setappdata(gcbf,'metricdata',data);

%--------------------------------------
% --- Executes on mouse press over axes background.
function konstelacja_cw1mouse(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
test=data.ktest;
x=get(gca,'CurrentPoint');
set(handles.wynPe,'String','');
set(handles.wynP01,'String','');
set(handles.wynP10,'String','');
set(handles.P01,'String','');
set(handles.P10,'String','');

if test==0
    if get(handles.polski,'Value')==1
        set(handles.informacja,'String','Wybierz drugi punkt');
    else
        set(handles.informacja,'String','Select second point');
    end
    set(handles.text29,'String','');
    set(handles.text30,'String','');
    data.kp1x = x(1);
    data.kp1y = x(3);
    test=1;
else
    set(handles.text31,'String','');
    set(handles.text32,'String','');
    p1x=data.kp1x;
    p1y=data.kp1y;
    a=[-2 2];
    if x(1)~=p1x %sprawdzanie czy nie ma prostej typu x=5
    y=((x(3)-p1y)/(x(1)-p1x))*(a-p1x)+p1y;
    hold on;
    if ishandle(data.kline)==1
        set(data.kline, 'XData', a, 'YData', y, 'Color', 'g');
    else
        data.kline = plot(a,y,'g','HitTest','off');
    end
    
    xdata = get(data.kline,'XData');
    ydata = get(data.kline,'YData');
    grid on;
    set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
    test=0;
    recmsga1=data.recmsga1;
    recmsga0=data.recmsga0;
    msg = data.msg;
    recmsg = data.recmsg;
    a1=data.a1;
    a0=data.a0;
    odb = recmsg;


    Y = imag(recmsg);
    X = real(recmsg);
    rs1 = 0;    %liczba odebranych jedynek
    rs0 = 0;    %liczba odebranych zer
    for (i = 1:1:size(recmsg,1))
        if ( Y(i) >= ((x(3)-p1y)/(x(1)-p1x))*(X(i) - p1x) + p1y )
            rs1 = rs1+1;
            odb(i) = a0;
        else
            rs0 = rs0+1;
            odb(i) = a1;
        end
    end

    p01 = 0;    %liczba blednie rozpoznanych jedynek
    p10 = 0;    %liczba blednie rozpoznanych zer
    for (i = 1:size(odb))
        if (odb(i)== a0)
            if(odb(i) == msg(i))
                p01 = p01;
            else
                p01 = p01 + 1;
            end
        else
            if(odb(i) == msg(i))
                p10 = p10;
            else
                p10 = p10 + 1;
            end
        end
    end
%     p10=p10
%     p01=p01
    wynp01 = p01/data.msglen;
    wynp10 = p10/data.msglen;
    wynPe = wynp01 + wynp10;
    P01 = p01/data.msg1;
%     msg0=data.msg0
    P10 = p10/data.msg0;
%     msg1=data.msg1
        
  
    set(handles.wynPe,'String',sprintf('%6.5f',wynPe));
    set(handles.wynP01,'String',sprintf('%6.5f',wynp01));
    set(handles.wynP10,'String',sprintf('%6.5f',wynp10));
    set(handles.P01,'String',sprintf('%6.5f',P01));
    set(handles.P10,'String',sprintf('%6.5f',P10));  
    if get(handles.polski,'Value')==1
        set(handles.informacja,'String','Rozpocznij symulacje od nowa lub ponownie okresl punkty, przez ktore przejdzie prosta decyzyjna. Przycisk "podpowiedz" wyrysuje optymalna prosta decyzyjna.');
    else
        set(handles.informacja,'String','Press "SIMULATION" to simulate again, or select two points one more time. Press "suggest" to draw optimal decision line.');    
    end
    
    end
    
end
data.ktest=test;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function konstelacja_cw2motion(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
x=get(gca,'CurrentPoint');
set(handles.text25,'String',x(1));
set(handles.text26,'String',x(3));
%--------------------------------------------------------------------------
% --- Executes on mouse press over axes background.
function konstelacja_cw2mouseAxes(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
if data.ktest==1
    data.ktest=0;
    point=get(gca,'CurrentPoint');
    info = get(data.kline,'UserData');
    %sprawdzanie np czy pkt nie jest za blisko 2
    set(data.kline,'XData',point(1),'YData',point(3),'MarkerEdgeColor','r','MarkerSize',25);
    data.syg(1,info)=point(1);
    data.syg(2,info)=point(3);
    setappdata(gcbf,'metricdata',data);

end
%--------------------------------------------------------------------------
function konstelacja_cw3mouseAxes(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%---------------------------------------
% --- Executes on mouse press over axes background.
function konstelacja_cw2mousePoint(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
if data.ktest==0            %pierwsze klikniecie
    data.ktest=1;
    info = get(hObject,'UserData');
    set(hObject,'MarkerEdgeColor','g','MarkerSize',15);
    data.kline = hObject;
    x = data.syg(1,info);

    y = data.syg(2,info);
else
    data.ktest=0;
    set(data.kline,'MarkerEdgeColor','r','MarkerSize',25);
    data.kline=-1;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes on mouse press over axes background.
function konstelacja_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to konstelacja (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%--------------------------------------------------------------------------
% --- Executes on mouse motion over figure - except title and menu.
function figure1_WindowButtonMotionFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton19.
function radiobutton19_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.text34,'String','');
set(handles.konstelacja,'Visible','on');
M=2;
cla;
hold on;
syg = [1 -1; 0 0];  %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'k.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' };
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end

grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton13.
function radiobutton13_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=8;
cla;
hold on;
syg = [1 0 -1 0 0.3 -0.3 -0.3 0.3; 0 1 0 -1 0.3 0.3 -0.3 -0.3];    %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton13
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton15.
function radiobutton15_Callback(hObject, eventdata, handles)    %radiobutton
% hObject    handle to radiobutton15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=8;
cla;
hold on;
syg = [1 0 -1 0 0.5 0 -0.5 0; 0 1 0 -1 0 0.5 0 -0.5];      %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton15
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton14.
function radiobutton14_Callback(hObject, eventdata, handles)    %radiobutton PSK(8)
% hObject    handle to radiobutton14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=8;
cla;
hold on;
x=0:M-1;    %ustalenie kata
syg = [real(exp(j*2*pi*x/M));imag(exp(j*2*pi*x/M))];   %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton14


% --- Executes on button press in radiobutton16.
function radiobutton16_Callback(hObject, eventdata, handles)    %radiobutton AM-PM(4,4)*
% hObject    handle to radiobutton16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=8;
cla;
hold on;
syg = [1 -1 -1  1 0  -0.9 0   0.9;...
    1  1 -1 -1 0.9 0  -0.9 0];      %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton16
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton21.
function radiobutton21_Callback(hObject, eventdata, handles)    %radiobutton PSK(4)=QAM(4)
% hObject    handle to radiobutton21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=4;
cla;
hold on;
syg = [1 -1 -1 1;1 1 -1 -1];
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton21
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton23.
function radiobutton23_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
cla;
hold on;
%x=[0:M-1];
syg = [-0.3 0.3 0.3 -0.3 0.3 -0.3 -0.9 0.9 -0.9 0.9 -0.9 0.9 -0.9 -0.3 0.3 0.9;...
    0.3 0.3 -0.3 -0.3 0.9 0.9 0.9 0.9 0.3 0.3 -0.3 -0.3 -0.9 -0.9 -0.9 -0.9];
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton23
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton24.
function radiobutton24_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
cla;
hold on;
x=0:M-1;    %ustalenie kata
syg = [real(exp(j*2*pi*x/M));imag(exp(j*2*pi*x/M))];   %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton24
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton25.
function radiobutton25_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
k=8;
cla;
hold on;
x=0:k-1;    %ustalenie kata
syg = [real(exp(j*2*pi*x/k)) real(0.5*exp(j*2*pi*x/k));imag(exp(j*2*pi*x/k)) imag(0.5*exp(j*2*pi*x/k))];   %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton25
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton26am.
function radiobutton26am_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton26am (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
k=8;
cla;
hold on;
x=0:k-1;    %ustalenie kata
syg = [real(exp(j*(2*pi*x/k+2*pi/16))) real(0.5*exp(j*2*pi*x/k));imag(exp(j*(2*pi*x/k+2*pi/16))) imag(0.5*exp(j*2*pi*x/k))];   %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton26am
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton27.    (1,5,10)
function radiobutton27_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
k=5;
l=10;
cla;
hold on;
x=0:l-1;    %ustalenie kata
y=0:k-1;
syg = [0 real(exp(j*2*pi*(x/l))) real(0.5*exp(j*2*pi*(y/k)));0 imag(exp(j*2*pi*(x/l))) imag(0.5*exp(j*2*pi*(y/k)))];   %punkty konstelacji
% syg = [0 real(exp(j*2*pi*(x/l+pi/2))) real(0.5*exp(j*2*pi*(y/k+pi)));0 imag(exp(j*2*pi*(x/l+pi/2))) imag(0.5*exp(j*2*pi*(y/k+pi)))];   %punkty konstelacji
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton27
%--------------------------------------------------------------------------
% --- Executes on button press in radiobutton28.
function radiobutton28_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.konstelacja,'Visible','on');
set(handles.text34,'String','');
M=16;
cla;
hold on;
syg = [0.25 -0.25 -0.25  0.25 0.6 0.6 0   -0.6 -0.6 -0.6  0    0.6 1 0 -1 0;...
    0.25  0.25 -0.25 -0.25 0   0.6 0.6  0.6  0   -0.6 -0.6 -0.6 0 1  0 -1];
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie konstelacji---
for (i=1:M)
    kol=kolor(i);
    plot(syg(1,i),syg(2,i),char(kol),'MarkerSize',15);
end
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
data.syg=syg;
data.M=M;
setappdata(gcbf,'metricdata',data);
% Hint: get(hObject,'Value') returns toggle state of radiobutton28
%--------------------------------------------------------------------------
function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
msglenvol2 = str2double(get(hObject, 'String'));
if isnan(msglenvol2)
    set(hObject,'String',25000);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end

data = getappdata(gcbf,'metricdata');
if isnan(msglenvol2)
    data.msglenvol2 = 25000;
else
    data.msglenvol2 = msglenvol2;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
% pole edycyjne dla dlugosci wiadomosci w czesci 2
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.msglenvol2 = 25000;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
snrvol2 = str2double(get(hObject, 'String'));
if isnan(snrvol2)
    set(hObject,'String',6);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end
data = getappdata(gcbf,'metricdata');
if isnan(snrvol2)
    data.snrvol2=6;
else
    data.snrvol2 = snrvol2;
end
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes during object creation, after setting all properties.
% pole edycyjne snr w czesci 2
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.snrvol2 = 6;
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------
% --- Executes on button press in pushbutton5.  guzik uruchamiajacy
% symulacje w cwiczeniu 2
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
set(handles.text34,'String','');
data = getappdata(gcbf,'metricdata');
cla;
msglen=data.msglenvol2;          %dlugosc informacji
snr=data.snrvol2;                %SNR

val = get(handles.popupmenu2,'Value');
switch val
    case 1
        M=2;
        bb=1;
    case 2
        M=4;
        bb=2;
    case 3
        M=8;
        bb=3;
    case 4
        M=16;
        bb=4;
end

nummslen = fix(msglen/M);         %liczba nadanych probek pojedynczej litery alfabetu. probki generowane sa z takim samym prawdopodobienstwem
syg=data.syg;
s=0;
for k=1:M                          %wyznaczanie mocy syg
    s=s + syg(1,k)*syg(1,k) + syg(2,k)*syg(2,k);
end
s=0.5*s/M;
%nvar= s/(bb*(10^(snr/10)));
%n=sqrt(nvar);                    %moc szumu
n = s/(bb*10^(snr/10));
%temp=ones(2,nummslen);          %macierz jedynkowa 2xnummsglen
%syg
%syg(:,1)
%TWORZENIE MACIERZY Z NADAWANYMI SYGNALAMI
rayleigh = get(handles.ray2,'Value');
awr = get(handles.AWR,'Value');
if rayleigh == 0
    temp=ones(2,nummslen);  
else
    temp=ones(2,nummslen); 
    ray = ones(1,nummslen);
    for i=1:nummslen
        a=raylrnd(1);
        %a=raylrnd(sqrt(2/pi));
        ray(i)=a;
        temp(1,i)=a*temp(1,i);
        temp(2,i)=a*temp(2,i);
        size(temp);
    end
    
end

for k=1:M
    msg(1,:,k)=syg(1,k)*temp(1,:);
    msg(2,:,k)=syg(2,k)*temp(2,:);
end

if awr == 0
    for k=1:M
        recmsg(:,:,k)=msg(:,:,k)+wgn2(size(msg(:,:,k),1), size(msg(:,:,k),2), n, 'linear','real');    %dodanie szumu bialego
    end
else
    ray2=[ray;ray];
    for k=1:M
        recmsg(:,:,k)=(msg(:,:,k)+wgn2(size(msg(:,:,k),1), size(msg(:,:,k),2), n, 'linear','real'))./ray2;    %dodanie szumu bialego
    end
end
d=ones(1,M);
zle=0;
dobrze=0;
Z=M;
%dla kazdej grupy mglawic i dla kazgego pkt w mglawicy jest obliczana
%odleglosc od kazdego pkt konstelacji, nastepnie wybierana jest najmniejsza
%odleglosc jako odebrany sygnal. jezeli najmniejsza odleglosc jest rowna
%odleglosci od startowego pkt konstelacji to nie ma bledu, w przeciwnym
%razie blad wystepuje
for c=1:Z
    for a=1:(nummslen)
        for b=1:M
            d(b)=sqrt((syg(1,b)-recmsg(1,a,c))^2+(syg(2,b)-recmsg(2,a,c))^2);      %odleglosc odebranego pkt od kazdego pkt konstelacji
        end
        mind = min(d);
        if mind~=d(c)
            zle=zle+1;
        else
            dobrze=dobrze+1;
        end

    end
end

mind;
d;
syg;
recmsg;
blad=zle;
dobre=dobrze;
Pe = zle/(nummslen*M);
set(handles.text34,'String',Pe);
%-------------------------------------------------------------------------
kolor = { 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.' 'r.' 'g.' 'b.' 'y.' 'm.' 'w.' 'b.' 'c.'};
%---rysowanie mglawicy---
cla;
%h = waitbar(0,'Please wait...');
do=fix(nummslen/10);
x=0;
h = waitbar(x,'Prosze czekac');
for od=1:do:9*fix(nummslen/10)
    x=x+0.1;
    waitbar(x)
    %h = waitbar(i,'Prosze czekac');
    for (i=1:M)

        kol=kolor(i);
        plot(handles.konstelacja,recmsg(1,od:od+do,i),recmsg(2,od:od+do,i),char(kol),'MarkerSize',3);

    end
end
close(h);
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
setappdata(gcbf,'metricdata',data);
%--------------------------------------------------------------------------

% --- Executes on button press in checkbox2.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox2


% --- Executes on mouse press over figure background.
function figure1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over checkbox2.
function checkbox2_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
data = getappdata(gcbf,'metricdata');
clear;
data.piersym = 0; 
data.cwiczenie=0;
data.numofpoints = 0;
data.konstelacja = [];
data.ktest=0;       %zmienna informujaca o 1 kliknieciu
data.kline=-1;
%data.konstelacja('test') = 0;
setappdata(gcbf,'metricdata',data);


% --- Executes on button press in ustawieniaReczne.
function ustawieniaReczne_Callback(hObject, eventdata, handles)
% hObject    handle to ustawieniaReczne (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
M=data.M;
syg=data.syg;
numofpoints=data.numofpoints;   %flaga reprezentujaca nam komplet pkt w konstelacji lub brak 1
cla;
%--------------------------------------------------------------------------
%rysowanie prostych co 30 stopni
x=[-3 3];
for alpha=0:pi/6:pi
    if alpha~=pi/2
        y=tan(alpha)*x;
        plot(y,x,'w:','HitTest','off');
    end
end
%--------------------------------------------------------------------------
grid on;

%-------
th = 0:pi/50:2*pi;
xunit = cos(th);
yunit = sin(th);
c82 = cos(82*pi/180);
s82 = sin(82*pi/180);
rticks=6;
rmin=0;
rmax=2;
rinc = (rmax-rmin)/rticks;
for i=(rmin+rinc):rinc:rmax
    line(xunit*i,yunit*i,'linestyle',':','color','w','linewidth',1,...
        'handlevisibility','on','parent',gca,'HitTest','off');
end
for (i=1:M)
    plot(syg(1,i),syg(2,i),'r.','LineWidth',1,'MarkerSize',25,'ButtonDownFcn',...
        'laboratorium(''konstelacja_cw2mousePoint'',gcbo,[],guidata(gcbo))','UserData',i);   %rysowanie konstelacji do zmiany
end
set(handles.konstelacja,'XTick',[-1.5 -1 -0.5 0 0.5 1 1.5],'YTick',[-1.5 -1 -0.5 0 0.5 1 1.5],'XLim',[-2 2],'YLim',[-2 2]);
setappdata(gcbf,'metricdata',data);



% --------------------------------------------------------------------
function save_Callback(hObject, eventdata, handles)
% hObject    handle to save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
M=data.M;
syg=data.syg;
[file,path] = uiputfile('*.mat','Zapisz jako');
zmienna=strcat(path,file);
save(zmienna, 'M', 'syg');

% --------------------------------------------------------------------
function open_Callback(hObject, eventdata, handles)
% hObject    handle to open (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
[file,path] = uigetfile('*.mat','Otworz');
open = load(strcat(path,file));
open.M;
open.syg;
data.M=open.M;
data.syg=open.syg;
setappdata(gcbf,'metricdata',data);
switch data.M               %mianowania - ustawianie popupmenu2
    case 2
        set(handles.popupmenu2,'Value',1);
        set(handles.uipanel15,'Visible','on');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','off');
    case 4
        set(handles.popupmenu2,'Value',2);
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','on');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','off');
    case 8
        set(handles.popupmenu2,'Value',3);
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','on');
        set(handles.uipanel17,'Visible','off');
    case 16
        set(handles.popupmenu2,'Value',4);
        set(handles.uipanel15,'Visible','off');
        set(handles.uipanel16,'Visible','off');
        set(handles.modulacja3,'Visible','off');
        set(handles.uipanel17,'Visible','on');
end
ustawieniaReczne_Callback(hObject, eventdata, handles);

% --------------------------------------------------------------------
function close_Callback(hObject, eventdata, handles)
% hObject    handle to close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(gcf);


% --- Executes on selection change in popupmenu3.
function popupmenu3_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu3 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu3
val = get(hObject,'Value');
switch val
    case 1
        axes(handles.bladkata);
        cla;
        set(handles.bladkata,'XTick',[0 pi],'YTick',0,'XLim',[0 pi],'YLim',[0 1]);
        axes(handles.konstelacja);
        %cla;
        set(handles.bladkata,'Visible','off');
        set(handles.hist,'Visible','off');
        set(handles.text39,'String','');

    case 2
        axes(handles.bladkata);
        cla;
        set(handles.bladkata,'XTick',[0 pi],'YTick',0,'XLim',[0 pi],'YLim',[0 1]);
        axes(handles.konstelacja);
        %cla;
        set(handles.bladkata,'Visible','on');
        set(handles.hist,'Visible','on');
        set(handles.text39,'String','');
end

% --- Executes during object creation, after setting all properties.
function popupmenu3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function edit11_Callback(hObject, eventdata, handles)
% hObject    handle to edit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit11 as text
%        str2double(get(hObject,'String')) returns contents of edit11 as a double
msglenvol3 = str2double(get(hObject, 'String'));
if isnan(msglenvol3)
    set(hObject,'String',25000);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end

data = getappdata(gcbf,'metricdata');
if isnan(msglenvol3)
    data.msglenvol3 = 25000;
else
    data.msglenvol3 = msglenvol3;
end
setappdata(gcbf,'metricdata',data);

% --- Executes during object creation, after setting all properties.
function edit11_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.msglenvol3 = 25000;
setappdata(gcbf,'metricdata',data);


function edit12_Callback(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit12 as text
%        str2double(get(hObject,'String')) returns contents of edit12 as a double
snrvol3 = str2double(get(hObject, 'String'));
if isnan(snrvol3)
    set(hObject,'String',6);
    errordlg('Nalezy wprowadzic liczbe','Zle');
end

data = getappdata(gcbf,'metricdata');
if isnan(snrvol3)
    data.snrvol3=6;
else
    data.snrvol3 = snrvol3;
end
setappdata(gcbf,'metricdata',data);

% --- Executes during object creation, after setting all properties.
function edit12_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.snrvol3 = 6;
setappdata(gcbf,'metricdata',data);



function edit13_Callback(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit13 as text
%        str2double(get(hObject,'String')) returns contents of edit13 as a double
kat = str2double(get(hObject, 'String'));
if (isnan(kat)||(kat<0)||(kat>180))
    set(hObject,'String',0);
    errordlg('Nalezy wprowadzic liczbe z zakresu [0,180]','Zle');
else

    data = getappdata(gcbf,'metricdata');
    if isnan(kat)
        data.kat=0;
    else
        data.kat = kat;
    end
    setappdata(gcbf,'metricdata',data);
    M=2;
    kat=(data.kat/360)*2*pi;    %ustalenie kata
    syg = [real(exp(j*(2*pi+kat))) real(exp(j*(2*pi+kat+pi)));imag(exp(j*(2*pi+kat))) imag(exp(j*(2*pi+kat+pi)))];   %punkty konstelacji
    kolor = { 'r.' 'g.'};
    %---rysowanie mglawicy---
    cla;
    for (i=1:M)
        kol=kolor(i);

        plot(handles.konstelacja,syg(1,i),syg(2,i),char(kol),'MarkerSize',5);

    end
    grid on;
    set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
end

% --- Executes during object creation, after setting all properties.
function edit13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
data = getappdata(gcbf,'metricdata');
data.kat = 0;
setappdata(gcbf,'metricdata',data);

% --- Executes on button press in pushbutton8.
function pushbutton8_Callback(hObject, eventdata, handles) %NADAJ
% hObject    handle to pushbutton8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.pushbutton9,'Enable','on');
axes(handles.bladkata);
cla;
axes(handles.konstelacja);
data = getappdata(gcbf,'metricdata');
clc;
set(handles.text39,'String','');
snr = data.snrvol3;                  %SNR
M = 2;                               %romiar alfabetu
msglen = data.msglenvol3;            %dlugosc informacji
kat=(data.kat/360)*2*pi;             %ustalenie kata
syg = [real(exp(j*(2*pi+kat))) real(exp(j*(2*pi+kat+pi)));imag(exp(j*(2*pi+kat))) imag(exp(j*(2*pi+kat+pi)))];   %punkty konstelacji
msgorig = randsrc( msglen, 1, [1 0; 0.5 0.5]);                  %generowanie wiadomosci
%msgorig=[1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ]
%msgorig=[1 0 1 0 1 0 1 0 1 0]
%msgorig=[1 1 1 1 1 1 1 1 1 1]
syg;
data.msgorig=msgorig;
msgsent=ones(2,msglen+1);
msgsent(1,1)=syg(1,1);
msgsent(2,1)=syg(2,1);
flaga=[syg(1,1);syg(2,1)];
%--------------------------------------------------------------------------
%Modulacja wiadomosci
for i=1:size(msgorig,1)
    if msgorig(i)==1
        msgsent(1,i+1)=msgsent(1,i);
        msgsent(2,i+1)=msgsent(2,i);
        flaga=[msgsent(1,i+1);msgsent(2,i+1)];
    else
        if ((flaga(1,1)==syg(1,1))&&(flaga(2,1)==syg(2,1)))
            msgsent(1,i+1)=syg(1,2);
            msgsent(2,i+1)=syg(2,2);
            flaga=[syg(1,2);syg(2,2)];
        else
            msgsent(1,i+1)=syg(1,1);
            msgsent(2,i+1)=syg(2,1);
            flaga=[syg(1,1);syg(2,1)];
        end
    end
end
testmsgsent = size(msgsent,2);
msg0=0;
msg1=0;
for i = 1:size(msgsent,2)
    if (msgsent(1,i) == syg(1,1))&&(msgsent(2,i)==syg(2,1))

        msg1=msg1+1;
    else
        msg0=msg0+1;
    end
end
%--------------------------------------------------------------------------
s=0;
for k=1:M                               %wyznaczanie mocy syg
    s=s + syg(1,k)*syg(1,k) + syg(2,k)*syg(2,k);
end
s=0.5*s/M;
n = s/(10^(snr/10));                 %moc szumu
recmsg3=msgsent+wgn2(size(msgsent,1), size(msgsent,2), n, 'linear', 'real');    %dodanie szumu bialego
size(recmsg3,2);
data.recmsg3=recmsg3;
data.msgsent=msgsent;
recmsga0=ones(2,msg0);
recmsga1=ones(2,msg1);
k=1;
n=1;
for i=1:size(msgsent,2)
    if(msgsent(1,i) == syg(1,1))&&(msgsent(2,i)==syg(2,1))
        recmsga1(1,k)=recmsg3(1,i);
        recmsga1(2,k)=recmsg3(2,i);
        k=k+1;
    else
        recmsga0(1,n)=recmsg3(1,i);
        recmsga0(2,n)=recmsg3(2,i);
        n=n+1;
    end
end
hold on;
cla;
%-------------------
msg0norm=fix(msg0/10);
msg1norm=fix(msg1/10);
x=0;
od0=1;
do0=0;
od1=1;
do1=0;
h = waitbar(x,'Prosze czekac');
for i=1:10
    x=x+0.1;
    waitbar(x)
    do1=i*msg1norm;
    do0=i*msg0norm;
    plot(handles.konstelacja,recmsga0(1,od0:do0),recmsga0(2,od0:do0),'g.','HitTest','off','MarkerSize',1); %------RYSUJEMY KONSTELACJE A0 i A1 sprawdz to!!!!
    plot(handles.konstelacja,recmsga1(1,od1:do1),recmsga1(2,od1:do1),'r.','HitTest','off','MarkerSize',1);
    od1=do1+1;
    od0=do0+0;
end
close(h);
grid on;
set(handles.konstelacja,'XTick',0,'YTick',0,'XLim',[-2 2],'YLim',[-2 2]);
%-------------------
% cla;
% plot(handles.konstelacja,recmsga0(1,:),recmsga0(2,:),'g.','HitTest','off','MarkerSize',1); %------RYSUJEMY KONSTELACJE A0 i A1 sprawdz to!!!!
% plot(handles.konstelacja,recmsga1(1,:),recmsga1(2,:),'r.','HitTest','off','MarkerSize',1);
setappdata(gcbf,'metricdata',data);


% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)   %ODBIERZ
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
val = get(handles.popupmenu3,'Value');
blad=0;
rec=2;
switch val
    case 1
        a='test koherentny';
        for i=2:size(data.msgsent,2)
            data.recmsg3(1,i-1);
            data.recmsg3(1,i);
            if sign(data.recmsg3(1,i))==sign(data.recmsg3(1,i-1))
                rec=1;
            else
                rec=0;
            end
            if data.msgorig(i-1)==rec
                %blad=blad;
            else
                blad=blad+1;
            end
        end
        pe=blad/data.msglenvol3;
        set(handles.text39,'String',pe)
        blad;

    case 2
        a='test niekoherentny';
        axes(handles.bladkata);


        cla;
        axes(handles.konstelacja);
        %temp=ones(2,nummslen);
        %kat = ones(1,size(data.msgsent,2)-1);
        if data.msglenvol3>=25000
            ilerysowac=25000;
        else
            ilerysowac = data.msglenvol3;
        end
        kat = ones(1,ilerysowac);

        for i=2:size(data.msgsent,2)
            decyzja = (data.recmsg3(1,i)*data.recmsg3(1,i-1))+(data.recmsg3(2,i)*data.recmsg3(2,i-1));
            if (i-1)<ilerysowac
                kat(i-1) = acos(decyzja/(sqrt((data.recmsg3(1,i))^2+(data.recmsg3(2,i))^2)*sqrt((data.recmsg3(1,i-1))^2+(data.recmsg3(2,i-1))^2)));
            end
            if decyzja > 0
                rec=1;

            else
                rec=0;

            end
            if data.msgorig(i-1)==rec

            else
                blad=blad+1;
            end

        end

        axes(handles.bladkata);
        hold on;
        co = 0:pi/180:pi;
        n=max(histc(kat,co));
        hist(kat,co);
        h = findobj(gca,'Type','patch');
        set(h,'FaceColor','g','EdgeColor','k')
        set(handles.bladkata,'XTick',[0 pi],'YTick',0,'XLim',[0 pi],'YLim',[0 1.1*n]);
        axes(handles.konstelacja);
        pe=blad/data.msglenvol3;
        set(handles.text39,'String',pe)

end


% --- Executes on button press in podpowiedz.
function podpowiedz_Callback(hObject, eventdata, handles)
% hObject    handle to podpowiedz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
%-----rysowanie podpowiedzi prostej decyzyjnej-----
%y=ax+b
a=-1;
x=[-2 2];
%przykladowy pkt do testw pkt=[0 0]
%---WYZNACZANIENIE PKT
snr = data.snr;                 %SNR
a0 = data.a0;
a1 = data.a1;
p0 = data.p0;
p1 = 1 - p0;
s=a0^2*p0+a1^2*p1;              %moc sygnalu
n = s/(10^(snr/10));            %moc szumu
zmienna1 = 2*n*log(p0/p1);
zmienna2 = sqrt((a0-a1)^2+(a0-a1)^2);   %odleglosc miedzy (a0,a0) i (a1,a1)
zmienna3 = (zmienna2^2-zmienna1)/(2*zmienna2);
zmienna4 = zmienna3/sqrt(2);
vx = zmienna4 + a1; %pkt przez ktory przechodzi prosta decyzyjna
pkt=[vx vx];
%----
b = pkt(1)-a*pkt(2);
y=a*x+b;
plot(y,x,'g:','HitTest','off');


% --- Executes during object creation, after setting all properties.
function bladkata_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bladkata (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate bladkata


% --- Executes on button press in rayleigh.
function rayleigh_Callback(hObject, eventdata, handles)
% hObject    handle to rayleigh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rayleigh


% --- Executes on button press in ray2.
function ray2_Callback(hObject, eventdata, handles)
% hObject    handle to ray2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ray2 = get(handles.ray2,'Value');
if ray2 == 0
    set(handles.AWR,'Visible','off');
    set(handles.AWR,'Value',0);
else
    set(handles.AWR,'Visible','on');
end
% Hint: get(hObject,'Value') returns toggle state of ray2


% --- Executes on button press in AWR.
function AWR_Callback(hObject, eventdata, handles)
% hObject    handle to AWR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of AWR


% --- Executes on button press in polski.
function polski_Callback(hObject, eventdata, handles)
% hObject    handle to polski (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.wersja,'Title','language');
set(handles.English,'String','English');
set(handles.polski,'String','polski');

set(handles.plik,'Label','Plik');
set(handles.save,'Label','Zapisz jako ...');
set(handles.open,'Label','Otworz ...');
set(handles.close,'Label','Zakoncz ...');
set(handles.koniecbutt,'String','KONIEC');

set(handles.cwiczenie,'Label','Cwiczenie');
set(handles.czesc1,'Label','Czesc I');
set(handles.czesc2,'Label','Czesc II');
set(handles.czesc3,'Label','Czesc III');

set(handles.panelvol1,'Title','Czesc I');
set(handles.dane1,'Title','Dane');
set(handles.ampa0,'String','amplituda a1');
set(handles.ampa1,'String','amplituda a0');
set(handles.prawdp0,'String','prawd p1');
set(handles.liczbaprobek,'String','liczba symboli');
set(handles.staticentropia,'String','Entropia=');
set(handles.symulacjabutt,'String','SYMULACJA');
set(handles.podpowiedz,'String','podpowiedz');

set(handles.wyniki1,'Title','Wyniki');
if data.piersym==0  %wskazuje pierwsze wykonanie sym
    set(handles.informacja,'String','Ustaw parametry symulacji a nastepnie klikajac przycisk "SYMULACJA", rozpocznij ja.');
end

set(handles.panelvol2,'Title','Czesc II');
set(handles.uipanel8,'Title','Rodzaj modulacji');
set(handles.ustawieniaReczne,'String','ustawienia reczne');
set(handles.modulacja3,'Title','Modulacja');
set(handles.uipanel15,'Title','Modulacja');
set(handles.uipanel16,'Title','Modulacja');
set(handles.uipanel17,'Title','Modulacja');
set(handles.uipanel18,'Title','Parametry');
set(handles.text27,'String','liczba symboli');
set(handles.ray2,'String','kanal Rayleigha');
set(handles.pushbutton5,'String','Symulacja');
set(handles.uipanel19,'Title','Wynik symulacji');

set(handles.panelvol3,'Title','Czesc III');
set(handles.uipanel20,'Title','Ustawienia');
set(handles.text40,'String','liczba symboli');
set(handles.text42,'String','B(w stopniach)');
set(handles.pushbutton8,'String','Nadaj');
set(handles.pushbutton9,'String','Odbierz');
set(handles.uipanel22,'Title','Wynik');
set(handles.hist,'String','Histogram mierzonych katow');
% Hint: get(hObject,'Value') returns toggle state of polski


% --- Executes on button press in English.
function English_Callback(hObject, eventdata, handles)
% hObject    handle to English (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = getappdata(gcbf,'metricdata');
set(handles.wersja,'Title','language');
set(handles.English,'String','English');
set(handles.polski,'String','polish');

set(handles.plik,'Label','File');
set(handles.save,'Label','Save as ...');
set(handles.open,'Label','Open ...');
set(handles.close,'Label','Exit ...');
set(handles.koniecbutt,'String','EXIT');

set(handles.cwiczenie,'Label','Exercise');
set(handles.czesc1,'Label','Part I');
set(handles.czesc2,'Label','Part II');
set(handles.czesc3,'Label','Part III');

set(handles.panelvol1,'Title','Part I');
set(handles.dane1,'Title','Data');
set(handles.ampa0,'String','amplitude a1');
set(handles.ampa1,'String','amplitude a0');
set(handles.prawdp0,'String','probability p1');
set(handles.liczbaprobek,'String','number of symbols');
set(handles.staticentropia,'String','Entropy=');
set(handles.symulacjabutt,'String','SIMULATION');
set(handles.podpowiedz,'String','suggest');

set(handles.wyniki1,'Title','Results');
if data.piersym==0
    set(handles.informacja,'String','Set parameters and press "SIMULATION"');
end

set(handles.panelvol2,'Title','Part II');
set(handles.uipanel8,'Title','Kind of modulation');
set(handles.ustawieniaReczne,'String','manual settings');
set(handles.modulacja3,'Title','Modulation');
set(handles.uipanel15,'Title','Modulation');
set(handles.uipanel16,'Title','Modulation');
set(handles.uipanel17,'Title','Modulation');
set(handles.uipanel18,'Title','Parameters');
set(handles.text27,'String','number of symbols');
set(handles.ray2,'String','Rayleigh channel');
set(handles.pushbutton5,'String','Simulation');
set(handles.uipanel19,'Title','Result');

set(handles.panelvol3,'Title','Part III');
set(handles.uipanel20,'Title','Settings');
set(handles.text40,'String','number of symbols');
set(handles.text42,'String','B(in degrees)');
set(handles.pushbutton8,'String','Send');
set(handles.pushbutton9,'String','Receive');
set(handles.uipanel22,'Title','Result');
set(handles.hist,'String','Histogram of measured angles');

% Hint: get(hObject,'Value') returns toggle state of English
