package sdh;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

import podstawy.Bajt;
import podstawy.Monitor;
import podstawy.Stan;



public class Odbiornik{

	private ArrayList ramka = new ArrayList();
	private Stan synchronizacji;
	private Stan poszukiwania;
	private ArrayList przedalarmowe = new ArrayList();
	private ArrayList potwierdzajace = new ArrayList();
	private short liczba_bajtow_synchronizacyjnych = 6;
	private String bajty_sprawdzajace;
	private int pozycja = 0;
	private Monitor monitor;
	
	public Odbiornik(int liczba_przedalarmowe, int liczba_potwierdzenia, boolean startSynchronizacji) {
		this.synchronizacji = new Stan();
		this.poszukiwania = new Stan();
		for (int i=0; i < liczba_przedalarmowe; i++) {
			Stan temp = new Stan();
			this.przedalarmowe.add(temp);
		}
		for (int i=0; i < liczba_potwierdzenia; i++) {
			Stan temp = new Stan();
			this.potwierdzajace.add(temp);
		}
		if (startSynchronizacji == true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
		this.zmien_liczbe_bajtow_synchronizacyjnych((short) 6);
		
		this.oblicz_dzielnik_rysunkow();
		
	}
	public void zmien_liczbe_bajtow_synchronizacyjnych(short liczba) {
		if (liczba < 7 && liczba > 0) {
			this.liczba_bajtow_synchronizacyjnych = liczba;
		}
		String temp = "";
		for (int i=0; i < this.liczba_bajtow_synchronizacyjnych; i++) {
			if(i < 3) {
				temp += Bajt.bity_synchronizacyjneA1;
			}
			else {
				temp += Bajt.bity_synchronizacyjneA2;
			}
		}
		this.bajty_sprawdzajace = temp;
	}
	public void dodaj_monitor(Monitor m) {
		this.monitor = m;
	}
	public short zwroc_liczbe_bajtow_synchronizacyjnych() {
		return this.liczba_bajtow_synchronizacyjnych;
	}
	public void dodaj_ramke(ArrayList r) {
		this.ramka = r;
	}
	public void synchronizacja() {
		boolean operacja_wykonana = false;
		if (this.synchronizacji.jaka_aktywnosc() == true) {
			//dzialaj synchronizacji
			this.dzialaj_synchronizacja();
			operacja_wykonana = true;
		}
		else if(this.poszukiwania.jaka_aktywnosc() ==true) {
			//dzialaj poszukiwania
			this.dzialaj_poszukiwanie();
			operacja_wykonana = true;
		}
		else {
			Iterator e = this.przedalarmowe.iterator();
			Stan stan;
			if (operacja_wykonana == false) {
				while (e.hasNext()) {
					stan = (Stan) e.next();
					if (stan.jaka_aktywnosc() == true) {
						//dzialaj przedalarmowy
						stan.wylacz_aktywnosc();
						this.dzialaj_przedalarmowe(e);
						operacja_wykonana = true;
						break;
					}
				}
			}
			if (operacja_wykonana == false) {
				e = this.potwierdzajace.iterator();
				while (e.hasNext()) {
					stan = (Stan) e.next();
					if (stan.jaka_aktywnosc() == true) {
						//dzialaj potwierdzajace
						stan.wylacz_aktywnosc();
						this.dzialaj_potwierdzenia(e);
						operacja_wykonana = true;
						break;
					}
				}
			}
		}
	}
	private String przygotuj_bajty() {
		String bajty = "";
		if (this.pozycja == 0) {
			for (int i =0; i < this.liczba_bajtow_synchronizacyjnych; i++) {
				Short temp = (Short) ramka.get(i);
				bajty += Bajt.zamien_na_String(temp.shortValue());
			}
		}
		else {
			int poczatek = this.pozycja / 8;
			int reszta = this.pozycja % 8;
			if (reszta > 0) {
				Short temp = (Short) ramka.get(poczatek);
				String wstepne_bity= Bajt.zamien_na_String(temp.shortValue());
				wstepne_bity = wstepne_bity.substring(reszta);
				bajty += wstepne_bity;
			}
			else {
				Short temp = (Short) ramka.get(poczatek);
				bajty += Bajt.zamien_na_String(temp.shortValue());
			}
			for (int i =poczatek+1; i < this.liczba_bajtow_synchronizacyjnych + poczatek; i++) {
				Short temp = (Short) ramka.get(i);
				bajty += Bajt.zamien_na_String(temp.shortValue());
			}
			if (reszta > 0) {
				Short temp = (Short) ramka.get(poczatek+this.liczba_bajtow_synchronizacyjnych+1);
				String koncowe_bity= Bajt.zamien_na_String(temp.shortValue());
				koncowe_bity = koncowe_bity.substring(0,reszta);
				bajty += koncowe_bity;
			}
		}
		return bajty;
	}
	private void dzialaj_synchronizacja() {
		if (this.pozycja != 0) {
			this.monitor.dodaj_zapis("SYNF");
		}
		else {
			this.monitor.dodaj_zapis("SYNT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		if (this.bajty_sprawdzajace.equals(bajty_odebrane) == false) {
			//przeskakujemy do przedalarmowych
			if (this.przedalarmowe.isEmpty()) {
				this.poszukiwania.wlacz_aktywnosc();
			}
			else {
				Stan temp = (Stan) this.przedalarmowe.get(0);
				temp.wlacz_aktywnosc();
				this.przedalarmowe.set(0,temp);
			}
			this.synchronizacji.wylacz_aktywnosc();
		}
		else {
			this.synchronizacji.wlacz_aktywnosc();
		}
	}
	private void dzialaj_przedalarmowe(Iterator element) {
		if (this.pozycja != 0) {
			this.monitor.dodaj_zapis("ALRF");
		}
		else {
			this.monitor.dodaj_zapis("ALRT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		//((Stan) element).wylacz_aktywnosc();
		if (this.bajty_sprawdzajace.equals(bajty_odebrane)== true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
			else {
				this.poszukiwania.wlacz_aktywnosc();
			}
		}
	}
	private void dzialaj_poszukiwanie() {
		this.monitor.dodaj_zapis("POS");
		String bajty_odebrane ="";
		int liczba_operacji = this.ramka.size() / 15;
		int poz=-1;
		boolean znalazlem = false;
		for (int i=0; i < liczba_operacji; i++) {
			bajty_odebrane ="";
			for (int k =0; k <15; k++) {
				Short temp = (Short) this.ramka.get(i*15+k);
				bajty_odebrane += Bajt.zamien_na_String(temp.shortValue());
			}
			poz = bajty_odebrane.indexOf(this.bajty_sprawdzajace);
			if (poz != -1) {
				znalazlem = true;
				break;
			}
		}
		if (znalazlem == true) {
			this.pozycja = poz;
			this.poszukiwania.wylacz_aktywnosc();
			if (this.potwierdzajace.isEmpty() == true) {
				this.synchronizacji.wlacz_aktywnosc();
			}
			else {
				Stan stan = (Stan) this.potwierdzajace.get(0);
				stan.wlacz_aktywnosc();
				this.potwierdzajace.set(0,stan);
			}
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
	}
	private void dzialaj_potwierdzenia(Iterator element) {
		if (this.pozycja != 0) {
			this.monitor.dodaj_zapis("POTF");
		}
		else {
			this.monitor.dodaj_zapis("POTT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		//((Stan) element).wylacz_aktywnosc();
		if (this.bajty_sprawdzajace.equals(bajty_odebrane)== false) {
			this.poszukiwania.wlacz_aktywnosc();
		}
		else {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
			else {
				this.synchronizacji.wlacz_aktywnosc();
			}
		}
	}
	private void oblicz_dzielnik_rysunkow() {
		this.dzielnik_do_rysunku = 4;
		int liczba_stanow_posrednich = Math.max(this.przedalarmowe.size(), this.potwierdzajace.size());
		if (liczba_stanow_posrednich == 1) {
			this.dzielnik_do_rysunku = 5;
		}
		else if(liczba_stanow_posrednich >= 2) {
			this.dzielnik_do_rysunku = 5+2*(liczba_stanow_posrednich-1);
		}
		
	}
	private int dzielnik_do_rysunku;
	public void rysuj(Graphics g, int W, int H) {
		int h = (H-20)/this.dzielnik_do_rysunku;
		int x=0;
		int y=0;
		Font czcionka = g.getFont();
		g.setFont(new Font(czcionka.getName(), Font.BOLD, czcionka.getSize()));
		//Rysuje stan Synchronizacji
		int liczba_odwiedzin = this.synchronizacji.zwroc_liczbe_odwiedzin();
		x= 10;
		y= 10;
		if (this.synchronizacji.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1, y-1, W-18, h+2);
		}
		g.setColor(new Color(238, 201, 0));
		g.fillRoundRect(x, y, W-20, h, 20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2,y+(h/2));
		
		//Rysuje stan Poszukiwania
		liczba_odwiedzin = this.poszukiwania.zwroc_liczbe_odwiedzin();
		y=H-20-h;
		if (this.poszukiwania.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1,y-1, W-18 ,h+2);
		}
		g.setColor(new Color(178, 223, 238));
		g.fillRoundRect(x,y, W-20 ,h,20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2, y+(h/2));
		
		//Rysuje stany przedalarmowe
		Iterator e = this.przedalarmowe.iterator();
		y = 10;
		Stan temp;
		while(e.hasNext()) {
			y = y + 2*h;
			temp = (Stan) e.next();
			liczba_odwiedzin = temp.zwroc_liczbe_odwiedzin();
			if(temp.jaka_aktywnosc()) {
				g.setColor(Color.RED);
				g.fillRect(x-1, y-1,((W-20)/4)+2, h+2);
			}
			g.setColor(new Color(162, 205, 90));
			g.fillRoundRect(x, y, (W-20)/4, h, 20, 20);
			g.setColor(Color.BLACK);
			g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/8, y+(h/2));
			//Rysuje strzalke od stanu poprzedniego do obecnego
			g.drawLine(x+(W-20)/8, y-h, x+(W-20)/8, y);
			g.drawLine(x+(W-20)/8, y-h/2,x+(W-20)/8-2, y-h/2-4 );
			g.drawLine(x+(W-20)/8, y-h/2,x+(W-20)/8+2, y-h/2-4);
			//Rysuje strzalke od stanu przedalarmowego do stanu synchronizacji
			g.drawLine(x+(W-20)/4, y+h/2, x+(W-20)/4+(W-20)/8, y+h/2);
			g.drawLine(x+(W-20)/4+(W-20)/8, y+h/2, x+(W-20)/4+(W-20)/8, 10+h);
			g.drawLine(x+(W-20)/4+(W-20)/8, y, x+(W-20)/4+(W-20)/8-2, y+4);
			g.drawLine(x+(W-20)/4+(W-20)/8, y, x+(W-20)/4+(W-20)/8+2, y+4);
		}
		//Rysuje strzalke koncowa od stanu przedalarmowego do poszukiwania
		g.drawLine(x+(W-20)/8, y+h,x+(W-20)/8, H-20-h);
		g.drawLine(x+(W-20)/8, y+h+h/2, x+(W-20)/8-2, y+h+h/2-4);
		g.drawLine(x+(W-20)/8, y+h+h/2, x+(W-20)/8+2, y+h+h/2-4);
		//Rysuje stany potwierdzenia
		e = this.potwierdzajace.iterator();
		x=3*((W-20)/4);
		y=H-20-h;
		while(e.hasNext()) {
			y = y - 2*h;
			temp = (Stan) e.next();
			liczba_odwiedzin = temp.zwroc_liczbe_odwiedzin();
			if(temp.jaka_aktywnosc()) {
				g.setColor(Color.RED);
				g.fillRect(x-1, y-1,((W-20)/4)+2, h+2);
			}
			g.setColor(new Color(205,193,197));
			g.fillRoundRect(x, y, (W-20)/4, h, 20, 20);
			g.setColor(Color.BLACK);
			g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/8, y+(h/2));
			//Rysuje strzalke od stanu poprzedniego do stanu obecnego
			g.drawLine(x+(W-20)/8, y+2*h, x+(W-20)/8, y+h);
			g.drawLine(x+(W-20)/8, y+(2*h)-(h/2),x+(W-20)/8+2, y+(2*h)-(h/2)+4);
			g.drawLine(x+(W-20)/8, y+(2*h)-(h/2),x+(W-20)/8-2, y+(2*h)-(h/2)+4);
			//Rysuje strzalki powrotne do stanu poszukiwania
			g.drawLine(x, y+h/2, x-(W-20)/8, y+h/2);
			g.drawLine(x-(W-20)/8, y+h/2, x-(W-20)/8, H-20-h);
			g.drawLine(x-(W-20)/8, y+h, x-(W-20)/8-2,y+h-4);
			g.drawLine(x-(W-20)/8, y+h, x-(W-20)/8+2,y+h-4);
		}
		//koncowa strzalka od stanu potwierdzenia
		g.drawLine(x+(W-20)/8, y, x+(W-20)/8, 10+h);
		g.drawLine(x+(W-20)/8, y-(h/2),x+(W-20)/8+2, y-(h/2)+4);
		g.drawLine(x+(W-20)/8, y-(h/2),x+(W-20)/8-2, y-(h/2)+4);
		
	}

}
