package sdh;

import gui.Gui;

import java.awt.Graphics;
import java.awt.Image;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

import podstawy.Monitor;


public class BadaniePanel extends JPanel implements Runnable{

	private Thread watek;
	private Gui zarzadca;
	private Monitor monitor;
	private Odbiornik odbiornik;
	private Image rysunek;
	
	public BadaniePanel(Gui z, Monitor m) {
		this.zarzadca = z;
		this.monitor = m;
		//System.out.println("Jestem w konstruktorze");
	}
	
	public void start() {
		watek = new Thread(this, "BadaniePanelSDH");
		this.watek.start();
	}
	public void run() {
		//System.out.println("Start");
		this.zarzadca.odswiez();
		this.rysunek = this.createImage(this.getWidth(), this.getHeight());
		STM1 stm1;
		this.odbiornik = new Odbiornik(this.zarzadca.jaka_liczba_stanow_przedalarmowych(),this.zarzadca.jaka_liczba_stanow_potwierdzenia(),this.zarzadca.jaki_start());
		this.odbiornik.zmien_liczbe_bajtow_synchronizacyjnych(this.zarzadca.jaka_liczba_bajtow_synchronizacyjnych());
		this.odbiornik.dodaj_monitor(monitor);
		int i=0;
		while(i< this.zarzadca.jaka_liczba_ramek_testowych()) {
			//this.rysunek = this.createImage(this.getWidth(), this.getHeight());
			stm1 = new STM1(this.zarzadca.jakie_dane_uzykownika());
			stm1.przeklam_bajty_synchronizacyjne(this.zarzadca.jaki_ber());
			this.odbiornik.dodaj_ramke(stm1.zwroc_ramke());
			this.odbiornik.synchronizacja();
			this.repaint();
			try {
				Thread.sleep(0);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			i++;
		}
		this.watek =null;
		this.zarzadca.zakonczono_badanie();
		JOptionPane.showMessageDialog(this.zarzadca.zwroc_glowne_okno(), "Badanie systemu SDH zakoczyo si.", "Powiadomienie", JOptionPane.INFORMATION_MESSAGE);
		//System.out.println("Koniec badania");
	}


	public void paint(Graphics g) {
		this.rysunek = this.createImage(this.getWidth(), this.getHeight());
		Graphics ekran = null;
		ekran = g;
		try {
			g = rysunek.getGraphics();
			this.odbiornik.rysuj(g, this.getWidth(), this.getHeight());
		}catch(NullPointerException blad) {
			System.out.println("Bad rysowania panelu badania");
		}
		ekran.drawImage(rysunek, 0,0, null);
		
		
	}

}
