package rozproszony;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;


public class Ramka {

	private ArrayList ramka = new ArrayList();
	private boolean dane_losowe = true;
	private boolean czyJedynka = true;
	private int liczba_bitow;
	private int pozycja_synchronizacyjna;
	
	public Ramka(int liczba, boolean wart) {
		this.liczba_bitow = liczba;
		this.czyJedynka = wart;
		this.pozycja_synchronizacyjna = 2*this.liczba_bitow/3;
		this.init();
	}
	public Ramka(int liczba, boolean wart, boolean los) {
		this.liczba_bitow = liczba;
		this.czyJedynka = wart;
		this.pozycja_synchronizacyjna = 2*this.liczba_bitow/3;
		this.dane_losowe = los;
		this.init();
	}
	private void init() {
		for (int i=0; i < this.liczba_bitow; i++) {
			if(i== this.pozycja_synchronizacyjna) {
				if(this.czyJedynka == true) {
					this.ramka.add(new Integer(1));
				}
				else {
					this.ramka.add(new Integer(0));
				}
			}
			else {
				if(this.dane_losowe == true) {
					this.ramka.add(new Integer(Ramka.zaokraglenie(Math.random())));
				}
				else {
					this.ramka.add(new Integer(1));
				}
			}
		}
	}
	private static int zaokraglenie(double liczba) {
		if(liczba >= 0.5) {
			return 1;
		}
		else {
			return 0;
		}
	}
	public ArrayList zwroc_ramke() {
		return this.ramka;
	}
	public void przeklam_bajty_synchronizacyjne(double ber) {
		Random random = new Random();
		double poczatek = this.wybierzPoczatekPrzedzialu(ber);
		double koniec = this.wybierzKoniecPrzedzialu(ber);
		if(this.dane_losowe==true) {
			double los = random.nextDouble();
			if(los>=poczatek && los < koniec) {
				Integer temp = (Integer) this.ramka.get(this.pozycja_synchronizacyjna);
				int bit = temp.intValue();
				if (bit == 1) {
					this.ramka.set(this.pozycja_synchronizacyjna, new Integer(0));
				}
				else {
					this.ramka.set(this.pozycja_synchronizacyjna, new Integer(1));
				}
			}
		}
		else {
			for (int i = 0; i < this.ramka.size(); i++) {
				double los = random.nextDouble();
				if(los>=poczatek && los < koniec) {
					Integer temp = (Integer) this.ramka.get(i);
					int bit = temp.intValue();
					if (bit == 1) {
						this.ramka.set(i, new Integer(0));
					}
					else {
						this.ramka.set(i, new Integer(1));
					}
				}
			}
		}
	}
	private double wybierzPoczatekPrzedzialu(double ber) {
		double start = 0;
		start  = 0.5 - (ber/2);
		return start;
	}
	
	private double wybierzKoniecPrzedzialu(double ber) {
		double koniec = 1;
		koniec = 0.5 + (ber/2);
		return koniec;
	}
	public void wyswietl() {
		Iterator e = this.ramka.iterator();
		String text = "Ramka: ";
		while(e.hasNext()) {
			text +=((Integer) e.next()).toString();
		}
		System.out.println(text);
		System.out.println("Pozycja synchronizacyjna(" + this.pozycja_synchronizacyjna + "):" +
				((Integer) this.ramka.get(this.pozycja_synchronizacyjna)).toString());
		
	}

	public static void main(String[] args) {
		Ramka ramka = new Ramka(8,true,false);
		ramka.wyswietl();
		//System.out.println("Liczba bitw: " + ramka.zwroc_ramke().size());
		ramka.przeklam_bajty_synchronizacyjne(0.1);
		ramka.wyswietl();
		//System.out.println("Liczba bitw: " + ramka.zwroc_ramke().size());
	}
}
