package rozproszony;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

import podstawy.Monitor;
import podstawy.Stan;

public class Odbiornik {

	private ArrayList ramka = new ArrayList();
	private ArrayList poprzednia_ramka = new ArrayList();
	private int liczba_przetworzonych_ramek =1;
	private int od_ramki_w_tym_stanie =0;
	private int pozycja_synchronizacji=0;
	private int poprawna_pozycja =0;
	private int g_pozycji_synchronizacji=0;
	private ArrayList wyliczone_g = new ArrayList();
	private Stan synchronizacji;
	private Stan poszukiwania;
	private Monitor monitor;
	private int bufor_poszukiwania;
	private int bufor_synchronizacji;
	private int prog_synchronizacji;
	
	public Odbiornik(int bufor_pos, int bufor_syn,int prog_syn, boolean startSynchronizacji) {
		this.synchronizacji = new Stan();
		this.poszukiwania = new Stan();
		if (startSynchronizacji == true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
		this.bufor_poszukiwania = bufor_pos;
		this.bufor_synchronizacji = bufor_syn;
		this.prog_synchronizacji = prog_syn;
	}
	public void dodaj_monitor(Monitor m) {
		this.monitor = m;
	}
	public void dodaj_ramke(ArrayList r) {
		this.ramka = r;
		if(this.liczba_przetworzonych_ramek==1) {
			this.poprawna_pozycja =  2*this.ramka.size()/3;
			this.pozycja_synchronizacji = this.poprawna_pozycja;
			this.wyzeruj_wyliczone_g();
		}
	}
	public void synchronizacja() {
		if(this.liczba_przetworzonych_ramek %2 == 0) {
			if(this.synchronizacji.jaka_aktywnosc()==true) {
				this.dzialaj_synchronizacja();
			}
			else if(this.poszukiwania.jaka_aktywnosc() == true) {
				this.dzialaj_poszukiwania();
			}
		}
		else {
			this.poprzednia_ramka = this.ramka;
			if(this.synchronizacji.jaka_aktywnosc()==true) {
				this.synchronizacji.wlacz_aktywnosc();
				if(this.pozycja_synchronizacji == this.poprawna_pozycja) {
					this.monitor.dodaj_zapis("SYNT");
				}
				else {
					this.monitor.dodaj_zapis("SYNF");
				}
			}
			if(this.poszukiwania.jaka_aktywnosc()==true) {
				this.poszukiwania.wlacz_aktywnosc();
				this.monitor.dodaj_zapis("POS");
			}
		}
		this.liczba_przetworzonych_ramek++;
	}
	private void dzialaj_poszukiwania() {
		this.monitor.dodaj_zapis("POS");
		this.wylicz_g_dla_tablicy();
		if(this.liczba_przetworzonych_ramek- this.od_ramki_w_tym_stanie >=2*this.bufor_poszukiwania) {
			int nowa_pozycja = this.znajdz_pozycje_synchro();
			if( nowa_pozycja != -1) {
				this.synchronizacji.wlacz_aktywnosc();
				this.poszukiwania.wylacz_aktywnosc();
				this.pozycja_synchronizacji = nowa_pozycja;
				this.od_ramki_w_tym_stanie = this.liczba_przetworzonych_ramek;
				this.wyzeruj_wyliczone_g();
			}
			else {
				this.poszukiwania.wlacz_aktywnosc();
				//this.zminiejsz_g_dla_tablicy();
				this.od_ramki_w_tym_stanie = this.liczba_przetworzonych_ramek;
				this.wyzeruj_wyliczone_g();
			}
		}else {
			this.poszukiwania.wlacz_aktywnosc();
		}
		
	}
	private void dzialaj_synchronizacja() {
		if(this.pozycja_synchronizacji == this.poprawna_pozycja) {
			this.monitor.dodaj_zapis("SYNT");
		}
		else {
			this.monitor.dodaj_zapis("SYNF");
		}
		int bit1 = ((Integer) this.ramka.get(this.pozycja_synchronizacji)).intValue();
		int bit2 = ((Integer) this.poprzednia_ramka.get(this.pozycja_synchronizacji)).intValue();
		if(bit1!= bit2) {
			this.g_pozycji_synchronizacji++;
		}
		if(this.liczba_przetworzonych_ramek- this.od_ramki_w_tym_stanie >=2*this.bufor_synchronizacji) {
			if (this.g_pozycji_synchronizacji >= this.prog_synchronizacji) {
				this.synchronizacji.wlacz_aktywnosc();
				//this.g_pozycji_synchronizacji--;
				this.g_pozycji_synchronizacji = 0;
				this.od_ramki_w_tym_stanie = this.liczba_przetworzonych_ramek;
			}
			else {
				this.synchronizacji.wylacz_aktywnosc();
				this.poszukiwania.wlacz_aktywnosc();
				this.g_pozycji_synchronizacji = 0;
				this.od_ramki_w_tym_stanie = this.liczba_przetworzonych_ramek;
			}
		}
		else {
			this.synchronizacji.wlacz_aktywnosc();
		}
	}
	private int znajdz_pozycje_synchro() {
		Iterator e = this.wyliczone_g.iterator();
		int max = 0;
		int pozycja = 0;
		int max_pozycja =-1;
		while(e.hasNext()) {
				int wart = ((Integer) e.next()).intValue();
				if(max < wart) {
					max = wart;
					max_pozycja =pozycja;
				}
				pozycja++;
		}
			return max_pozycja;
	}
	private void wyzeruj_wyliczone_g() {
		this.wyliczone_g.clear();
		for(int i=0; i <this.ramka.size(); i++) {
			this.wyliczone_g.add(new Integer(0));
		}
	}
	private void wylicz_g_dla_tablicy() {
		for (int i=0; i < this.ramka.size(); i++) {
			int bit1 = ((Integer) this.ramka.get(i)).intValue();
			int bit2 = ((Integer) this.poprzednia_ramka.get(i)).intValue();
			if(bit1!= bit2) {
				int g = 0;
				try {
					g = ((Integer) this.wyliczone_g.get(i)).intValue();
				}catch(IndexOutOfBoundsException exp) {
					g=0;
					this.wyliczone_g.add(new Integer(0));
				}
				g++;
				this.wyliczone_g.set(i, new Integer(g));				
			}
		}
	}
	private void zminiejsz_g_dla_tablicy() {
		for (int i=0; i < this.wyliczone_g.size(); i++) {
			int g = ((Integer) this.wyliczone_g.get(i)).intValue();
			g--;
			if (g < 0) {
				g =0;
			}
			this.wyliczone_g.set(i, new Integer(g));				
		}
	}
	public void rysuj(Graphics g, int W, int H) {
		int h = (H-20)/4;
		int x=0;
		int y=0;
		Font czcionka = g.getFont();
		g.setFont(new Font(czcionka.getName(), Font.BOLD, czcionka.getSize()));
		//Rysuje stan Synchronizacji
		int liczba_odwiedzin = this.synchronizacji.zwroc_liczbe_odwiedzin();
		x= 10;
		y= 10;
		if (this.synchronizacji.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1, y-1, W-18, h+2);
		}
		g.setColor(new Color(238, 201, 0));
		g.fillRoundRect(x, y, W-20, h, 20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2,y+(h/2));
		
		//Rysuje stan Poszukiwania
		liczba_odwiedzin = this.poszukiwania.zwroc_liczbe_odwiedzin();
		y=H-20-h;
		if (this.poszukiwania.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1,y-1, W-18 ,h+2);
		}
		g.setColor(new Color(178, 223, 238));
		g.fillRoundRect(x,y, W-20 ,h,20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2, y+(h/2));
		
		//strzalka od synchronizacji do poszukiwania
		g.drawLine(x+(W-20)/16, y, x+(W-20)/16, 10+h);
		g.drawLine(x+(W-20)/16, y-(h/2),x+(W-20)/16+2, y-(h/2)-4);
		g.drawLine(x+(W-20)/16, y-(h/2),x+(W-20)/16-2, y-(h/2)-4);
		
		//strzaka od stanu poszukiwania do stanu synchronizacji
		g.drawLine((W-20)-(W-20)/16, y, (W-20)-(W-20)/16, 10+h);
		g.drawLine((W-20)-(W-20)/16, y-(h/2), (W-20)-(W-20)/16+2, y-(h/2)+4);
		g.drawLine((W-20)-(W-20)/16, y-(h/2), (W-20)-(W-20)/16-2, y-(h/2)+4);
		
		
		
		
		
	}

}
