package rozproszony;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class Obliczenia {
		private double ber; //Pe
		private int dlugosc_ramki; //N
		private int bufor_poszukiwania;
		private int bufor_synchronizacji; //n
		private int prog_synchronizacji; //j
		private boolean dane_losowe;
		private BigDecimal Pcs1; //P(cs =1)
		private BigDecimal Pcs0; //P(cs =0)
		private ArrayList Pgs_rowne_j = new ArrayList(); //P(gs=j)
		private ArrayList Pgs_wieksze_od_j = new ArrayList(); //P(gs >= j)
		private ArrayList Pgd_rowne_j = new ArrayList(); //P(gd = j)
		private ArrayList Pgd_wieksze_od_j = new ArrayList(); //P(gd >= j)
		private ArrayList Pgd_mniejsze_od_j = new ArrayList(); //P(gd < j)
		private ArrayList Pdgd_wieksze_od_j = new ArrayList(); //Pd(gd >= j)
		private ArrayList Pmax_gd = new ArrayList(); 
		private BigDecimal Pzp;
		private BigDecimal Pzf;
		private BigDecimal Pnz;
		private BigDecimal Paf;
		private BigDecimal Pap;
		private ArrayList Pgs_rowne_jSYN = new ArrayList();
		private ArrayList Pgd_rowne_jSYN = new ArrayList();
		
		private void oblicz_Pcs1() {
			BigDecimal liczba = new BigDecimal(1);
			BigDecimal BER = new BigDecimal(this.ber ,MathContext.DECIMAL64);
			liczba = liczba.subtract(BER.multiply(new BigDecimal(2)));
			liczba = liczba.add((BER.pow(2)).multiply(new BigDecimal(2)));
			//System.out.println("P(cs=1) = " + liczba.toString());
			this.Pcs1 = liczba;
		}
		private void oblicz_Pcs0() {
			BigDecimal liczba = new BigDecimal(1);
			BigDecimal BER = new BigDecimal(this.ber ,MathContext.DECIMAL64);
			liczba = BER.multiply(new BigDecimal(2));
			liczba = liczba.subtract((BER.pow(2)).multiply(new BigDecimal(2)));
			//liczba = 2*this.ber - 2*Math.pow(this.ber, 2);
			//System.out.println("P(cs=0) = " + liczba.toString());
			this.Pcs0 = liczba;
		}
		private void oblicz_Pgs_rowne_j() {
			BigDecimal liczba = new BigDecimal(0);
			int j = 0;
			for (j=0; j <= this.bufor_poszukiwania; j++) {
				BigDecimal temp1 = Obliczenia.newton(this.bufor_poszukiwania, j);
				BigDecimal temp2 = this.Pcs1.pow(j);
				BigDecimal temp3 = this.Pcs0.pow(this.bufor_poszukiwania - j);
				liczba = temp1.multiply(temp2);
				liczba = liczba.multiply(temp3, MathContext.DECIMAL64);
				
				//System.out.println("t1= " + temp1 + ", t2= " + temp2 + ", t3= " + temp3);
				//System.out.println("P(gs=" + j + ")= " + liczba.toString());
				this.Pgs_rowne_j.add(liczba);
			}
			//Sprawdzenie => suma P(gs=j) powinna da 1
			BigDecimal suma =new BigDecimal(0);
			Iterator e = this.Pgs_rowne_j.iterator();
			while (e.hasNext()) {
				BigDecimal obj = (BigDecimal) e.next();
				suma = suma.add(obj,MathContext.DECIMAL64);
			}
			if (suma.equals(new BigDecimal(1))) {
				//System.out.println("Suma P(gs=j) jest rwna 1");
			}
			else {
				//System.out.println("Suma P(gs=j) jest rna od 1. Suma wynosi " + suma);
			}
		}
		private void oblicz_Pgs_wieksze_od_j() {
			BigDecimal liczba =new BigDecimal(0);
			//szybki sposob, czyli dodawanie wynikw P(gs=j)
			int j =0;
			for (j =0; j <= this.bufor_poszukiwania; j++) {
				liczba =new BigDecimal(0);
				int k =0;
				for (k=j; k<=this.bufor_poszukiwania; k++) {
					BigDecimal ObjTemp = (BigDecimal) this.Pgs_rowne_j.get(k);
					liczba = liczba.add(ObjTemp, MathContext.DECIMAL64);
				}
				//System.out.println("P(gs>=" + j + ")= " + liczba.toString());
				this.Pgs_wieksze_od_j.add(liczba);
			}
			
			
		}
		private void oblicz_Pgd_rowne_j() {
			BigDecimal liczba = new BigDecimal(0);
			int j =0;
			for (j=0; j <= this.bufor_poszukiwania; j++ ) {
				BigDecimal temp1 = Obliczenia.newton(this.bufor_poszukiwania, j);
				if (this.dane_losowe == true) {
					BigDecimal temp2 = (new BigDecimal(1)).divide((new BigDecimal(2)).pow(this.bufor_poszukiwania), MathContext.DECIMAL64);
					liczba = temp1.multiply(temp2);
					//System.out.println("t1= " + temp1 + ", t2= " + temp2);
				}
				else {
					BigDecimal Pcd0 = this.Pcs1;
					BigDecimal Pcd1 = this.Pcs0;
					BigDecimal temp2 = Pcd1.pow(j);
					BigDecimal temp3 = Pcd0.pow(this.bufor_poszukiwania - j);
					liczba = temp1.multiply(temp2);
					liczba = liczba.multiply(temp3);
				}
				//System.out.println("P(gd=" + j + ")= " + liczba.toString());
				this.Pgd_rowne_j.add(liczba);
			}
			//Sprawdzenie => suma P(gd=j) powinna da 1
			BigDecimal suma =new BigDecimal(0);
			Iterator e = this.Pgd_rowne_j.iterator();
			while (e.hasNext()) {
				BigDecimal obj = (BigDecimal) e.next();
				suma = suma.add(obj);
			}
			if (suma.equals(new BigDecimal(1, MathContext.DECIMAL64))) {
				//System.out.println("Suma P(gd=j) jest rwna 1");
			}
			else {
				//System.out.println("Suma P(gd=j) jest rna od 1. Suma wynosi " + suma);
			}
		}
		private void oblicz_Pgd_wieksze_od_j() {
			BigDecimal liczba= new BigDecimal(0);
			int j=0;
			for (j =0; j <= this.bufor_poszukiwania; j++) {
				liczba = new BigDecimal(0);
				int k =0;
				for (k=j; k<=this.bufor_poszukiwania; k++) {
					BigDecimal ObjTemp = (BigDecimal) this.Pgd_rowne_j.get(k);
					liczba = liczba.add(ObjTemp, MathContext.DECIMAL64);
				}
				//System.out.println("P(gd>=" + j + ")= " + liczba.toString());
				
				this.Pgd_wieksze_od_j.add(liczba);
			}
		}
		private void oblicz_Pgd_mniejsze_od_j() {
			BigDecimal liczba = new BigDecimal(0);
			int j=0;
			Iterator e = this.Pgd_wieksze_od_j.iterator();
			while (e.hasNext()) {
				liczba = new BigDecimal(0);
				BigDecimal objTemp = (BigDecimal) e.next();
				liczba = (new BigDecimal(1)).subtract(objTemp);
				//System.out.println("P(gd<" + j +")= " + liczba.toString());
				this.Pgd_mniejsze_od_j.add(liczba);
				j++;
			}
		}
		private void oblicz_Pdgd_wieksze_od_j() {
			BigDecimal liczba = new BigDecimal(0);
			int j =0;
			Iterator e = this.Pgd_mniejsze_od_j.iterator();
			while(e.hasNext()) {
				liczba = new BigDecimal(0);
				BigDecimal objPgd = (BigDecimal) e.next();
				BigDecimal temp1 = objPgd.pow(this.dlugosc_ramki - 1);
				liczba = (new BigDecimal(1)).subtract(temp1, MathContext.DECIMAL64);
				//System.out.println("Pd(gd>=" + j + ")= " + liczba.toString());
				this.Pdgd_wieksze_od_j.add(liczba);
				j++;
			}
		}
		private void oblicz_Pmax_gd() {
			BigDecimal liczba1 = new BigDecimal(0);
			BigDecimal liczba2 = new BigDecimal(0);
			BigDecimal wynik = new BigDecimal(0);
			int j =0;
			Iterator e = this.Pdgd_wieksze_od_j.iterator();
			while (e.hasNext()) {
				BigDecimal temp1 = (BigDecimal) e.next();
				BigDecimal temp2;
				if (j==0) {
					if(e.hasNext()) {
						temp2 = (BigDecimal) e.next();
					}
					else {
						temp2 = new BigDecimal(0);
					}
					liczba1 = temp1;
					liczba2 = temp2;
				
				}else {
					liczba1 = liczba2;
					liczba2 = temp1;
				}
				wynik = liczba1.subtract(liczba2);
				//System.out.println("Pgdmax(" + j+ ")= " + wynik.toString());
				
				this.Pmax_gd.add(wynik);
				j++;
			}
			wynik = (new BigDecimal(1)).subtract(wynik);
			//System.out.println("Pgdmax(" + j+ ")= " + wynik.toString());
			
			this.Pmax_gd.add(wynik);
		}
		private void oblicz_Pzp() {
			BigDecimal liczba = new BigDecimal(0);
			Iterator ePgs = this.Pgs_rowne_j.iterator();
			Iterator ePdgd = this.Pdgd_wieksze_od_j.iterator();
			while(ePgs.hasNext() && ePdgd.hasNext()) {
				BigDecimal obj1 = (BigDecimal) ePgs.next();
				BigDecimal obj2 = (BigDecimal) ePdgd.next();
				obj2 = (new BigDecimal(1)).subtract(obj2);
				liczba = liczba.add(obj1.multiply(obj2), MathContext.DECIMAL64);
			}
			//System.out.println("Pzp = " + liczba.toString());
			this.Pzp = liczba;
		}
		private void oblicz_Pzf() {
			BigDecimal liczba = new BigDecimal(0);
			//liczba = 1 - this.Pnz - this.Pzp;
			
			Iterator ePgs = this.Pgs_rowne_j.iterator();
			Iterator ePgd = this.Pdgd_wieksze_od_j.iterator();
			if (ePgd.hasNext()) {
				ePgd.next();
			}
			BigDecimal temp1 =new BigDecimal(0);
			BigDecimal temp2 =new BigDecimal(0);
			int j =0;
			while (ePgs.hasNext()) {
				temp1 = (BigDecimal) ePgs.next();
				if (ePgd.hasNext()) {
					temp2 = (BigDecimal) ePgd.next();
				}else {
					break;
				}
				liczba = liczba.add(temp1.multiply(temp2), MathContext.DECIMAL64);
				//System.out.println(j + ")" + temp1.toString() + " * " + temp2.toString() + " = " + liczba);
				j++;
			}
			//System.out.println("Pzf = " + liczba.toString());
			this.Pzf = liczba; 
		}
		private void oblicz_Pnz() {
			BigDecimal liczba = new BigDecimal(0);
			int j = 0;
			for (j=0; j <= this.bufor_poszukiwania; j++) {
				BigDecimal temp1 = (BigDecimal) this.Pgs_rowne_j.get(j);
				BigDecimal temp2 = (BigDecimal) this.Pdgd_wieksze_od_j.get(j);
				BigDecimal temp3;
				try {
					temp3 = (BigDecimal) this.Pdgd_wieksze_od_j.get(j+1);
				}
				catch(IndexOutOfBoundsException e) {
					temp3 =new BigDecimal(0);
				}
				
				liczba = liczba.add(temp1.multiply(temp2.subtract(temp3)), MathContext.DECIMAL64);
			//	System.out.println(j+ ")suma= " + liczba + " pgs= " + temp1 + ", pdj= " + temp2 + ",pdj+1= " + temp3);
			}
			//System.out.println("Pnz = " + liczba);
			this.Pnz = liczba;
		}
		private void oblicz_Pgs_rowne_j_dla_SYN() {
			BigDecimal liczba = new BigDecimal(0);
			int j = 0;
			for (j=0; j <= this.bufor_synchronizacji; j++) {
				BigDecimal temp1 = Obliczenia.newton(this.bufor_synchronizacji, j);
				BigDecimal temp2 = this.Pcs1.pow(j);
				BigDecimal temp3 = this.Pcs0.pow(this.bufor_synchronizacji - j);
				liczba = (temp1.multiply(temp2)).multiply(temp3, MathContext.DECIMAL64);
		//		System.out.println("P(gs=" + j + ")[SYN]= " + liczba);
				this.Pgs_rowne_jSYN.add(liczba);
			}
			//Sprawdzenie => suma P(gs=j) powinna da 1
			BigDecimal suma =new BigDecimal(0);
			Iterator e = this.Pgs_rowne_jSYN.iterator();
			while (e.hasNext()) {
				BigDecimal obj = (BigDecimal) e.next();
				suma = suma.add(obj, MathContext.DECIMAL64);
			}
			if (suma.equals(BigDecimal.ONE)) {
			//	System.out.println("Suma P(gs=j)[SYN] jest rwna 1");
			}
			else {
			//	System.out.println("Suma P(gs=j)[SYN] jest rna od 1. Suma wynosi " + suma);
			}
		}
		private void oblicz_Pgd_rowne_j_dla_SYN() {
			BigDecimal liczba =new BigDecimal(0);
			int j =0;
			for (j=0; j <= this.bufor_synchronizacji; j++ ) {
				BigDecimal temp1 = Obliczenia.newton(this.bufor_synchronizacji, j);
				if (this.dane_losowe == true) {
					BigDecimal temp2 = (new BigDecimal(1)).divide((new BigDecimal(2)).pow(this.bufor_synchronizacji), MathContext.DECIMAL64);
					liczba = temp1.multiply(temp2);
				}
				else {
					BigDecimal Pcd0 = this.Pcs1;
					BigDecimal Pcd1 = this.Pcs0;
					BigDecimal temp2 = Pcd1.pow(j);
					BigDecimal temp3 = Pcd0.pow(this.bufor_synchronizacji - j);
					liczba = (temp1.multiply(temp2)).multiply(temp3);
				}
		//		System.out.println("P(gd=" + j + ")[SYN]= " + liczba);
				this.Pgd_rowne_jSYN.add(liczba);
			}
			//Sprawdzenie => suma P(gd=j) powinna da 1
			BigDecimal suma = new BigDecimal(0);
			Iterator e = this.Pgd_rowne_jSYN.iterator();
			while (e.hasNext()) {
				BigDecimal obj = (BigDecimal) e.next();
				suma = suma.add(obj);
			}
			if (suma.equals(new BigDecimal(1))) {
			//	System.out.println("Suma P(gd=j)[SYN] jest rwna 1");
			}
			else {
			//	System.out.println("Suma P(gd=j)[SYN] jest rna od 1. Suma wynosi " + suma);
			}
		}
		private void oblicz_Paf() {
			this.oblicz_Pgs_rowne_j_dla_SYN();
			BigDecimal liczba = new BigDecimal(0);
			Iterator e = this.Pgs_rowne_jSYN.iterator();
			int j=0;
			while (e.hasNext() && (j < this.prog_synchronizacji)) {
				BigDecimal obj = (BigDecimal) e.next();
				liczba = liczba.add(obj, MathContext.DECIMAL64);
				j++;
			}
			//System.out.println("Paf = " + liczba);
			this.Paf = liczba;
		}
		private void oblicz_Pap() {
			this.oblicz_Pgd_rowne_j_dla_SYN();
			BigDecimal liczba =new BigDecimal(0);
			Iterator e = this.Pgd_rowne_jSYN.iterator();
			int j=0;
			while (e.hasNext() && (j < this.prog_synchronizacji)) {
				BigDecimal obj = (BigDecimal) e.next();
				liczba = liczba.add(obj, MathContext.DECIMAL64);
				j++;
			}
			//System.out.println("Pap = " + liczba);
			this.Pap = liczba;
		}
		public static BigDecimal silnia(int liczba) {
			BigDecimal wynik = new BigDecimal(1);
			for (int i=1; i <= liczba; i++) {
				wynik = wynik.multiply(new BigDecimal(i));
			}
			//System.out.println("Silnia liczby " + liczba + " = " + wynik.toString());
			return wynik;
		}
		public static BigDecimal silnia(int liczba, int start) {
			BigDecimal wynik = new BigDecimal(1);
			for (int i=start+1; i <= liczba; i++) {
				wynik = wynik.multiply(new BigDecimal(i));
			}
			//System.out.println("Silnia liczby " + liczba + " = " + wynik);
			return wynik;
		}
		public static BigDecimal newton(int n, int k) {
			BigDecimal wynik = new BigDecimal(0);
			BigDecimal temp1 = new BigDecimal(0);
			BigDecimal temp2 = new BigDecimal(0);
			if (k >= n-k) {
				temp1 = silnia(n,k);
				temp2 = silnia(n-k);
			}
			else if( k < n-k) {
				temp1 = silnia(n, n-k);
				temp2 = silnia(k);
			}
			
			//System.out.println("t1= " + temp1 + " t2= " + temp2);
			wynik = temp1.divide(temp2,MathContext.DECIMAL64);
			//System.out.println("Newton("+ n + ", " + k +")= " + wynik);
			return wynik;
		}
		public void wstaw_ber(double liczba) {
			this.ber = liczba;
		}
		public void wstaw_dl_ramki(int liczba) {
			this.dlugosc_ramki = liczba;
		}
		public void wstaw_bufor_poszukiwania(int liczba) {
			this.bufor_poszukiwania = liczba;
		}
		public void wstaw_bufor_synchronizacji(int liczba) {
			this.bufor_synchronizacji = liczba;
		}
		public void wstaw_prog_synchronizacji(int liczba) {
			this.prog_synchronizacji = liczba;
		}
		public void wstaw_jakie_dane(boolean dane) {
			this.dane_losowe = dane;
		}
		public BigDecimal zwroc_Pcs1() {
			return this.Pcs1;
		}
		public BigDecimal zwroc_Pcs0() {
			return this.Pcs0;
		}
		public ArrayList zwroc_Pgs_rowne_j() {
			return this.Pgs_rowne_j;
		}
		public ArrayList zwroc_Pgs_wieksze_od_j() {
			return this.Pgs_wieksze_od_j;
		}
		public ArrayList zwroc_Pgd_rowne_j() {
			return this.Pgd_rowne_j;
		}
		public ArrayList zwroc_Pgd_wieksze_od_j() {
			return this.Pgd_wieksze_od_j;
		}
		public ArrayList zwroc_Pgd_mniejsze_od_j() {
			return this.Pgd_mniejsze_od_j;
		}
		public ArrayList zwroc_Pdgd_wieksze_od_j() {
			return this.Pdgd_wieksze_od_j;
		}
		public ArrayList zwroc_Pmax_gd() {
			return this.Pmax_gd;
		}
		public ArrayList zwroc_Pgs_rowne_jSYN() {
			return this.Pgs_rowne_jSYN;
		}
		public ArrayList zwroc_Pgd_rowne_jSYN() {
			return this.Pgd_rowne_jSYN;
		}
		public BigDecimal zwroc_Pzp() {
			return this.Pzp;
		}
		public BigDecimal zwroc_Pzf() {
			return this.Pzf;
		}
		public BigDecimal zwroc_Pnz() {
			return this.Pnz;
		}
		public BigDecimal zwroc_Paf() {
			return this.Paf;
		}
		public BigDecimal zwroc_Pap() {
			return this.Pap;
		}
		public void oblicz_wszystko() {
			this.oblicz_Pcs0();
			this.oblicz_Pcs1();
			this.oblicz_Pgs_rowne_j();
			this.oblicz_Pgs_wieksze_od_j();
			this.oblicz_Pgd_rowne_j();
			this.oblicz_Pgd_wieksze_od_j();
			this.oblicz_Pgd_mniejsze_od_j();
			this.oblicz_Pdgd_wieksze_od_j();
			this.oblicz_Pmax_gd();
			this.oblicz_Pzp();
			this.oblicz_Pzf();
			this.oblicz_Pnz();
			this.oblicz_Paf();
			this.oblicz_Pap();
			BigDecimal sum = new BigDecimal(0);
			sum = sum.add((this.Pzp.add(this.Pzf)).add(this.Pnz), MathContext.DECIMAL64);
			//System.out.println("Pzp + Pnz + Pzf= " + sum.toString());
		}
		public static void main(String[] args) {
			Obliczenia ob = new Obliczenia();
			ob.wstaw_ber(0.1);
			ob.wstaw_bufor_poszukiwania(2);
			ob.wstaw_jakie_dane(true);
			ob.wstaw_dl_ramki(60);
			ob.wstaw_bufor_synchronizacji(29);
			ob.wstaw_prog_synchronizacji(27);
			ob.oblicz_wszystko();
			
			
		}
	}


