package podstawy;

import java.util.ArrayList;
import java.util.Iterator;


public class Monitor {
	
	private ArrayList lista = new ArrayList();
	
	//Dane wejciowe
	private int liczba_ramek;
	private int liczba_stanow_przedalarmowych;
	private int liczba_stanow_potwierdzenia;
	private double ber;
	private short liczba_bajtow_synchronizacyjnych;
	private boolean start_od_synchronizacji;
	private boolean dane_losowe;
	private boolean wzor_symulowany;
	private int dlugosc_ramki;
	private int bufor_poszukiwania;
	private int bufor_synchronizacji;
	private int prog_synchronizacji;
	private int liczba_zdarzen =0;
	private float sigma = 0;
	
	public void dodaj_zapis(String zapis) {
		lista.add(zapis);
	}
	public void czysc_liste() {
		this.lista.clear();
	}
	public void wyswietl() {
		Iterator e = this.lista.iterator();
		int i=0;
		while (e.hasNext()) {
			System.out.print(e.next() + "|");
			i++;
			if (i == 7) {
				i=0;
				System.out.println("");
			}
		}
	}
	public int policzMAXczasuUtrzymania() {
		int max = 0;
		int i =0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNT".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i > max) {
					max = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (max == 0) {
			max = -1;
		}
		//System.out.println("max utrzymania: " + max);
		return max;
	}
	/**
	 * Metoda ma za zadanie znalezc najmniejsza liczbe ramek,
	 * ktra byla od stanu synchronizacji z prawidow
	 * pozycja do stanu poszukiwania.
	 * @return minimalna warto utrzymania synchronizacji
	 */
	public int policzMINczasuUtrzymania() {
		int min = lista.size();
		int i = 0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNT".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i < min && i > 0) {
					min = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (min == lista.size()) {
			min = -1;
		}
		//System.out.println("min utrzymania: " + min);
		return min;
	}
	/**
	 * Metoda ma za zadanie policzyc srednie utrzymanie stanu synchronizacji
	 * @return wartosc float okreslajaca srednie utrzymanie stanu synchronizacji
	 */
	public float policzAVGczasuUtrzymania() {
		float avg = 0;
		ArrayList tab = new ArrayList();
		//zbieram wszystkie wystapienia stanu SYN
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNT".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				tab.add(new Integer(i));
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
			/*if (e.hasNext() == false) {
				if (liczyc == true) {
					tab.add(new Integer(i));
				}
			}*/
		}
		//licze srednia czasu utrymania
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				avg +=temp.intValue();
			}
			avg = avg/tab.size(); 
		}
		else {
			avg = -1;
		}
		//System.out.println("avg utrzymania: " + avg);
		//Licze var(t)
		float var =0;
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				var +=Math.pow(temp.intValue() - avg, 2);
			}
			var = var/tab.size(); 
		}
		else {
			var = -1;
		}
		float sigma =0;
		sigma = var/tab.size();
		sigma = (float) Math.pow(sigma, 0.5);
		this.liczba_zdarzen = tab.size();
		this.sigma = sigma;
		//System.out.println("L = " + tab.size());
	//	System.out.println("sigma = " + sigma);
		return avg;
	}
	/**
	 * Metoda ma za zadanie znalezc maksymalna ilo ramek,
	 * ktra przesza od stanu synchronizaji z nie prawidowa pozycj 
	 * do stanu synchronizaji z prawidow.
	 * 
	 * @return maksymalna warto utraty synchronizaji
	 */
	public int policzMAXczasuUtratySyn() {
		int max = 0;
		int i =0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i > max) {
					max = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (max == 0) {
			max = -1;
		}
		//System.out.println("max utraty synchronizacji: " + max);
		return max;
	}
	/**
	 * Metoda ma za zadanie znalezc najmniejsza liczbe ramek,
	 * ktra przesza od stanu synchronizaji z nie prawidowa pozycj 
	 * do stanu synchronizaji z prawidow.
	 * @return minimalna warto utraty synchronizacji; -1 gdy nie
	 * ma minimialnej wartoci
	 */
	public int policzMINczasuUtratySyn() {
		int min = lista.size();
		int i = 0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i < min && i > 0) {
					min = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (min == lista.size()) {
			min = -1;
		}
		//System.out.println("min utraty synchronizacji: " + min);
		return min;
	}
	/**
	 * Metoda ma za zadanie policzyc sredni czas utraty synchronizacji
	 * @return wartosc float okreslajaca sredni czas utraty stanu synchronizacji
	 */
	public float policzAVGczasuUtratySyn() {
		float avg = 0;
		ArrayList tab = new ArrayList();
		//zbieram wszystkie wystapienia stanu POS
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				tab.add(new Integer(i));
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
			/*if (e.hasNext() == false) {
			if (liczyc == true) {
				tab.add(new Integer(i));
			}
			}*/
		}
		//licze srednia czasu utraty synchronizacji
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				avg +=temp.intValue();
			}
			avg = avg/tab.size();
		}
		else {
			avg = -1;
		}
		//System.out.println("avg utraty synchronizacji: " + avg);
		//Licze var(t)
		float var =0;
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				var +=Math.pow(temp.intValue() - avg, 2);
			}
			var = var/tab.size(); 
		}
		else {
			var = -1;
		}
		float sigma =0;
		sigma = var/tab.size();
		sigma = (float) Math.pow(sigma, 0.5);
		this.liczba_zdarzen = tab.size();
		this.sigma = sigma;
		//System.out.println("L = " + tab.size());
	//	System.out.println("sigma = " + sigma);
		return avg;
	}
	/**
	 * Metoda ma za zadanie znalezc maksymalna 
	 * warto czasu wykrycia braku synchronizaji, czyli ilosc ramek od 
	 * stanu synchronizacji z nieprawidow pozycj do stanu poszukiwania
	 * @return maksymalna warto czasu wykrycia braku synchronizacji
	 */
	public int policzMAXczasuWykrycia() {
		int max = 0;
		int i =0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i > max) {
					max = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (max == 0) {
			max = -1;
		}
		//System.out.println("max wykrycia: " + max);
		return max;
	}
	/**
	 * Metoda ma za zadanie znalezc najmniejsza liczbe ramek,
	 * ktra byla od stanu synchronizacji z nieprawidow
	 * pozycj do stanu poszukiwania
	 * @return minimalna warto czasu wykrywania braku synchronizacji
	 */
	public int policzMINczasuWykrycia() {
		int min = lista.size();
		int i = 0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i < min && i > 0) {
					min = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (min == lista.size()) {
			min = -1;
		}
		//System.out.println("min wykrycia: " + min);
		return min;
	}
	/**
	 * Metoda ma za zadanie policzyc sredni czas wykrycia braku synchronizacji
	 * @return wartosc float okreslajaca sredni czas wykrycia braku synchronizacji
	 */
	public float policzAVGczasuWykrycia() {
		float avg = 0;
		ArrayList tab = new ArrayList();
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("SYNF".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("POS".equals(temp)&& liczyc == true) {
				liczyc = false;
				tab.add(new Integer(i));
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
			/*if (e.hasNext() == false) {
			if (liczyc == true) {
				tab.add(new Integer(i));
			}
			}*/
		}
		//licze srednia
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				avg +=temp.intValue();
			}
			avg = avg/tab.size();
		}
		else {
			avg = -1;
		}
		//System.out.println("avg wykrycia: " + avg);
//		Licze var(t)
		float var =0;
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				var +=Math.pow(temp.intValue() - avg, 2);
			}
			var = var/tab.size(); 
		}
		else {
			var = -1;
		}
		float sigma =0;
		sigma = var/tab.size();
		sigma = (float) Math.pow(sigma, 0.5);
		this.liczba_zdarzen = tab.size();
		this.sigma = sigma;
		//System.out.println("L = " + tab.size());
	//	System.out.println("sigma = " + sigma);
		return avg;
	}
	/**
	 * Metoda ma za zadanie znalezc maksymalna warto czasu
	 * poszukiwania synchronizaji, czyli ilo ramek od stanu poszukiwania
	 * do stanu synchronizaji z prawidow pozycj
	 * @return maksymalna warto czasu poszukiwania synchronizacji
	 */
	public int policzMAXczasuPoszukiwania() {
		int max = 0;
		int i =0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("POS".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i > max) {
					max = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (max == 0) {
			max = -1;
		}
		//System.out.println("max poszukiwania: " + max);
		return max;
	}
	/**
	 * Metoda ma za zadanie znalezc najmniejsza liczbe ramek,
	 * ktra bya od stanu poszukiwania
	 * do stanu synchronizaji z prawidow pozycj
	 * @return minimalna warto czasu poszukiwania synchronizacji
	 */
	public int policzMINczasuPoszukiwania() {
		int min = lista.size();
		int i = 0;
		boolean liczyc = false;
		Iterator e = lista.iterator();
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("POS".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				if (i < min && i > 0) {
					min = i;
				}
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
		}
		if (min == lista.size()) {
			min = -1;
		}
		//System.out.println("min poszukiwania: " + min);
		return min;
	}
	/**
	 * Metoda ma za zadanie policzyc sredni czas poszukiwania stanu synchronizacji
	 * @return wartosc float okreslajaca sredni czas poszukiwania stanu synchronizacji
	 */
	public float policzAVGczasuPoszukiwania() {
		float avg = 0;
		ArrayList tab = new ArrayList();
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("POS".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if ("SYNT".equals(temp)&& liczyc == true) {
				liczyc = false;
				tab.add(new Integer(i));
				i =0;
			}
			if(liczyc == true) {
				i++;
			}
			/*if (e.hasNext() == false) {
			if (liczyc == true) {
				tab.add(new Integer(i));
			}
			}*/
		}
		//licze srednia
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				avg +=temp.intValue();
			}
			avg = avg/tab.size();
		}
		else {
			avg = -1;
		}
		//System.out.println("avg poszukiwania: " + avg);
//		Licze var(t)
		float var =0;
		if (tab.size() > 0) {
			e = tab.iterator();
			while (e.hasNext()) {
				Integer temp = (Integer) e.next();
				var +=Math.pow(temp.intValue() - avg, 2);
			}
			var = var/tab.size(); 
		}
		else {
			var = -1;
		}
		float sigma =0;
		sigma = var/tab.size();
		sigma = (float) Math.pow(sigma, 0.5);
		this.liczba_zdarzen = tab.size();
		this.sigma = sigma;
		//System.out.println("L = " + tab.size());
		//System.out.println("sigma = " + sigma);
		return avg;
	}
	public int policz_liczbe_falszywych_pozycji() {
		int liczba =0;
		ArrayList tab = new ArrayList();
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("POS".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if("SYNF".equals(temp) && liczyc == true) {
				liczba++;
				liczyc = false;
			}
		}
		return liczba;
	}
	public int policz_liczbe_dobrych_pozycji() {
		int liczba =0;
		ArrayList tab = new ArrayList();
		Iterator e = lista.iterator();
		int i=0;
		boolean liczyc = false;
		while (e.hasNext()) {
			String temp = (String) e.next();
			if ("POS".equals(temp)&& liczyc == false) {
				liczyc = true;
			}
			if("SYNT".equals(temp) && liczyc == true) {
				liczba++;
				liczyc = false;
			}
		}
		return liczba;
	}
	public void dodaj_liczbe_ramek(int liczba) {
		this.liczba_ramek = liczba;
	}
	public void dodaj_liczbe_stanow_przedalarmowych(int liczba) {
		this.liczba_stanow_przedalarmowych = liczba;
	}
	public void dodaj_liczbe_stanow_potwierdzenia(int liczba) {
		this.liczba_stanow_potwierdzenia = liczba;
	}
	public void dodaj_ber(double liczba) {
		this.ber = liczba;
	}
	public void dodaj_liczbe_bajtow_synchronizacyjnych(short liczba) {
		this.liczba_bajtow_synchronizacyjnych = liczba;
	}
	public void dodaj_start_od_synchronizacji(boolean start) {
		this.start_od_synchronizacji = start;
	}
	public void dodaj_dane_losowe(boolean dane) {
		this.dane_losowe = dane;
	}
	public void dodaj_wzor_symulowany(boolean decyzja) {
		this.wzor_symulowany = decyzja;
	}
	public void dodaj_dlugosc_ramki(int liczba) {
		this.dlugosc_ramki = liczba;
	}
	public void dodaj_bufor_poszukiwania(int liczba) {
		this.bufor_poszukiwania= liczba;
	}
	public void dodaj_bufor_synchronizacji(int liczba) {
		this.bufor_synchronizacji= liczba;
	}
	public void dodaj_prog_synchronizacji(int liczba) {
		this.prog_synchronizacji = liczba;
	}
	public int zwroc_liczbe_ramek() {
		return this.liczba_ramek;
	}
	public int zwroc_liczbe_stanow_potwierdzenia() {
		return this.liczba_stanow_potwierdzenia;
	}
	public int zwroc_liczbe_stanow_przedalarmowych() {
		return this.liczba_stanow_przedalarmowych;
	}
	public double zwroc_ber() {
		return this.ber;
	}
	public short zwroc_liczbe_bajtow_synchronizacyjnych() {
		return this.liczba_bajtow_synchronizacyjnych;
	}
	public boolean zwroc_start_od_synchronizacji() {
		return this.start_od_synchronizacji;
	}
	public boolean zwroc_dane_losowe() {
		return this.dane_losowe;
	}
	public boolean zwroc_wzor_symulowany() {
		return this.wzor_symulowany;
	}
	public int zwroc_dlugosc_ramki() {
		return this.dlugosc_ramki;
	}
	public int zwroc_bufor_poszukiwania() {
		return this.bufor_poszukiwania;
	}
	public int zwroc_bufor_synchronizacji() {
		return this.bufor_synchronizacji;
	}
	public int zwroc_prog_synchronizacji() {
		return this.prog_synchronizacji;
	}
	public int zwroc_liczbe_zdarzen() {
		return this.liczba_zdarzen;
	}
	public float zwroc_sigme() {
		return this.sigma;
	}
}
