package pcm;

import java.util.ArrayList;

import podstawy.Bajt;



public class RamkaPCM {
	
	private ArrayList ramka = new ArrayList();
	private boolean dane_losowe = true;
	private boolean symulacja_wzoru = false;
	private int numerRamki;
	public static String bajt_synchronizacyjny_parzysty = "00011011";
	public static String bajt_synchronizacyjny_nieparzysty = "01000000";
	
	public RamkaPCM(int numer) {
		this.numerRamki = numer;
		this.wypelenijRamkeBajtami();
	}
	public RamkaPCM(int numer, boolean los) {
		this.numerRamki = numer;
		this.dane_losowe = los;
		this.wypelenijRamkeBajtami();
	}
	public RamkaPCM(int numer, boolean los, boolean sym) {
		this.numerRamki = numer;
		this.dane_losowe = los;
		this.symulacja_wzoru = sym;
		this.wypelenijRamkeBajtami();
	}
	private void wypelenijRamkeBajtami() {
		if(this.numerRamki %2 == 0) {
			this.wstawBitySzczeliny0RamkaParzysta();
		}
		else {
			this.wstawBitySzczeliny0RamkaNieparzysta();
		}
		if(this.dane_losowe == true) {
			this.generuj_bajty_uzytkowniaka(15);
		}
		else {
			this.generuj_bajty_nielosowe(15);
		}
		if (this.numerRamki %16 == 0) {
			this.wstawBitySzczeliny16Ramka0();
		}
		else {
			this.wstaw_bajty_sygnalizacyjne();
		}
		
		if(this.dane_losowe == true) {
			this.generuj_bajty_uzytkowniaka(15);
		}
		else {
			this.generuj_bajty_nielosowe(15);
		}
	}
	public void wstaw_symulacje_wzoru(boolean sym) {
		this.symulacja_wzoru = sym;
		if (this.symulacja_wzoru== true) {
			if(this.ramka.isEmpty() == false) {
				Short symulacja = new Short(Bajt.zamien_na_liczbe(this.bajt_synchronizacyjny_parzysty));
				this.ramka.set(10, symulacja);				
			}
		}
	}
	private void dodaj_bajt(short bajt) {
		Short temp = new Short(bajt);
		this.ramka.add(temp);
	}
	public short zwroc_bajt(int pozycja) {
		Short temp = (Short) ramka.get(pozycja);
		return temp.shortValue();
	}
	private void generuj_bajty_uzytkowniaka(int liczba_bajtow) {
		for (int i=0; i < liczba_bajtow; i++) {
			this.dodaj_bajt(Bajt.losuj_liczbe_bajt());
		}
	}
	
	private void wstawBitySzczeliny0RamkaNieparzysta() {
		this.dodaj_bajt(Bajt.zamien_na_liczbe(RamkaPCM.bajt_synchronizacyjny_nieparzysty));
	}
	private void wstawBitySzczeliny16Ramka0() {
		String bajt = "00001011";
		this.dodaj_bajt(Bajt.zamien_na_liczbe(bajt));
	}
	
	private void wstawBitySzczeliny0RamkaParzysta() {
		this.dodaj_bajt(Bajt.zamien_na_liczbe(RamkaPCM.bajt_synchronizacyjny_parzysty));
	}
	private void generuj_bajty_nielosowe(int liczba) {
		short bajt = Bajt.zamien_na_liczbe("11111111");
		for (int i=0; i < liczba; i++) {
			this.dodaj_bajt(bajt);
		}
	}
	private void wstaw_bajty_sygnalizacyjne() {
		String bajt = "00101110";
		this.dodaj_bajt(Bajt.zamien_na_liczbe(bajt));
	}
	public ArrayList zwroc_ramke() {
		return this.ramka;
	}
	public void przeklam_bajty_synchronizacyjne(double ber) {
		Short liczba = (Short) this.ramka.get(0);
		Bajt temp = new Bajt(liczba.shortValue());
		temp.przeklam_bajt(ber);
		liczba = new Short(temp.zwrocLiczbe());
		this.ramka.set(0,liczba);
		if (this.dane_losowe == false) {
			for (int i=1; i < this.ramka.size(); i++) {
				liczba = (Short) this.ramka.get(i);
				temp = new Bajt(liczba.shortValue());
				temp.przeklam_bajt(ber);
				liczba = new Short(temp.zwrocLiczbe());
				this.ramka.set(i,liczba);
			}
		}
	}
	public void wyswietl() {
		System.out.println("Liczba szczelin: " + this.ramka.size());
		System.out.println("Szczelina 0: " + Bajt.zamien_na_String(((Short)this.ramka.get(0)).shortValue()));
		System.out.println("Szczelina 10: " + Bajt.zamien_na_String(((Short)this.ramka.get(10)).shortValue()));
		System.out.println("Szczelina 16: " + Bajt.zamien_na_String(((Short)this.ramka.get(16)).shortValue()));
	}
	
	public static void main(String[] args) {
		RamkaPCM ramka = new RamkaPCM(0);
		ramka.wyswietl();
		ramka.przeklam_bajty_synchronizacyjne(0.02);
		ramka.wstaw_symulacje_wzoru(true);
		ramka.wyswietl();
		ramka = new RamkaPCM(1);
		ramka.wyswietl();
	}
}
