package gui;


import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

import podstawy.Bajt;
import podstawy.Monitor;


public class StatPanel extends JPanel{

	private static final long serialVersionUID = -8427727732355308047L;
	
	private Monitor monitor;
	
	public StatPanel(Monitor m) {
		this.monitor = m;
		this.init();
	}
	private void init() {
		this.setLayout(new GridLayout(22,1));
		//this.monitor.wyswietl();
		//Czas poszukiwania synchronizacji
		JLabel text = new JLabel("Czas poszukiwania synchrozniacji:", JLabel.CENTER);
		text.setForeground(Color.BLUE);
		this.add(text);
		JPanel panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("redni:", JLabel.RIGHT);
		panel.add(text);
		float liczbaFloat = this.monitor.policzAVGczasuPoszukiwania();
		if (liczbaFloat <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(Bajt.pokazWprzystepnejFormie(liczbaFloat) + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Maksymalny:", JLabel.RIGHT);
		panel.add(text);
		int liczbaInt = this.monitor.policzMAXczasuPoszukiwania();
		if (liczbaInt < 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Minimalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMINczasuPoszukiwania();
		if (liczbaInt < 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		int liczba_zd = this.monitor.zwroc_liczbe_zdarzen();
		String tekst = "Liczba zdarze: " + liczba_zd;
		text = new JLabel(tekst,JLabel.CENTER);
		panel.add(text);
		tekst = "Przedzia ufnoci: ";
		if (liczba_zd == 0) {
			tekst += "--"; 
		}
		else {
			tekst += Bajt.pokazWprzystepnejFormie(this.monitor.zwroc_sigme());
		}
		text = new JLabel(tekst, JLabel.CENTER);
		panel.add(text);
		this.add(panel);
		
		//Czas utrzymania synchronizacji
		text = new JLabel("Czas utrzymania synchrozniacji", JLabel.CENTER);
		text.setForeground(Color.BLUE);
		this.add(text);
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("redni:", JLabel.RIGHT);
		panel.add(text);
		liczbaFloat = this.monitor.policzAVGczasuUtrzymania();
		if (liczbaFloat <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(Bajt.pokazWprzystepnejFormie(liczbaFloat) + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Maksymalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMAXczasuUtrzymania();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Minimalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMINczasuUtrzymania();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		liczba_zd = this.monitor.zwroc_liczbe_zdarzen();
		tekst = "Liczba zdarze: " + liczba_zd;
		text = new JLabel(tekst,JLabel.CENTER);
		panel.add(text);
		tekst = "Przedzia ufnoci: ";
		if (liczba_zd == 0) {
			tekst += "--"; 
		}
		else {
			tekst += Bajt.pokazWprzystepnejFormie(this.monitor.zwroc_sigme());
		}
		text = new JLabel(tekst, JLabel.CENTER);
		panel.add(text);
		this.add(panel);
		
		
		//Czas utraty synchronizacji
		text = new JLabel("Czas utraty synchrozniacji", JLabel.CENTER);
		text.setForeground(Color.BLUE);
		this.add(text);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("redni:", JLabel.RIGHT);
		panel.add(text);
		liczbaFloat = this.monitor.policzAVGczasuUtratySyn();
		if (liczbaFloat <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(Bajt.pokazWprzystepnejFormie(liczbaFloat) + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Maksymalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMAXczasuUtratySyn();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Minimalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMINczasuUtratySyn();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		liczba_zd = this.monitor.zwroc_liczbe_zdarzen();
		tekst = "Liczba zdarze: " + liczba_zd;
		text = new JLabel(tekst,JLabel.CENTER);
		panel.add(text);
		tekst = "Przedzia ufnoci: ";
		if (liczba_zd == 0) {
			tekst += "--"; 
		}
		else {
			tekst += Bajt.pokazWprzystepnejFormie(this.monitor.zwroc_sigme());
		}
		text = new JLabel(tekst, JLabel.CENTER);
		panel.add(text);
		this.add(panel);
		
		//Czas wykrycia synchronizacji
		text = new JLabel("Czas wykrycia braku synchrozniacji:", JLabel.CENTER);
		text.setForeground(Color.BLUE);
		this.add(text);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("redni:", JLabel.RIGHT);
		panel.add(text);
		liczbaFloat = this.monitor.policzAVGczasuWykrycia();
		if (liczbaFloat <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(Bajt.pokazWprzystepnejFormie(liczbaFloat) + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Maksymalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMAXczasuWykrycia();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Minimalny:", JLabel.RIGHT);
		panel.add(text);
		liczbaInt = this.monitor.policzMINczasuWykrycia();
		if (liczbaInt <= 0) {
			text = new JLabel("--", JLabel.CENTER);
		}
		else {
			text = new JLabel(liczbaInt + " ramek", JLabel.CENTER);
		}
		panel.add(text);
		this.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		liczba_zd = this.monitor.zwroc_liczbe_zdarzen();
		tekst = "Liczba zdarze: " + liczba_zd;
		text = new JLabel(tekst,JLabel.CENTER);
		panel.add(text);
		tekst = "Przedzia ufnoci: ";
		if (liczba_zd == 0) {
			tekst += "--"; 
		}
		else {
			tekst += Bajt.pokazWprzystepnejFormie(this.monitor.zwroc_sigme());
		}
		text = new JLabel(tekst, JLabel.CENTER);
		panel.add(text);
		this.add(panel);
		
		this.add(new JLabel(""));
		
		int liczba = this.monitor.policz_liczbe_dobrych_pozycji();
		tekst = "Znaleziono " + liczba + " prawidowych pozycji synchronizacyjnych i";
		liczba = this.monitor.policz_liczbe_falszywych_pozycji();
		tekst += " " + liczba + " nieprawidowych.";
		text = new JLabel(tekst, JLabel.CENTER);
		text.setForeground(new Color(64, 160, 48));
		this.add(text);
	}
}
