package gui;


import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import podstawy.Bajt;


public class OknoDane implements ActionListener, FocusListener, WindowListener {
	
	//private static int MAX_liczba_ramek_testowych = 500000;
	private static int MAX_liczba_stanow_przedalarmowych = 6;
	private static int MAX_liczba_stanow_potwierdzenia = 6;
	private static int MIN_liczba_stanow_potwierdzenia = 2;
	private static int MAX_liczba_bajtow_synchronizacyjnych = 6;
	
	private Gui zarzadca;
	private JDialog okno;
	private JTextField pole_ramek_testowych;
	private JTextField pole_stanow_potwierdzenia;
	private JTextField pole_stanow_przedalarmowych;
	private JTextField pole_ber;
	private JTextField pole_bajtow_synchronizacyjnych;
	private ButtonGroup grupa_start;
	private ButtonGroup grupa_losowosc_danych;
	private ButtonGroup grupa_wzoru_symulowanego;
	
	private boolean czy_sdh;
	
	public OknoDane(Gui z, boolean jakie) {
		this.zarzadca = z;
		this.czy_sdh = jakie;
		this.init();
	}
	
	private void init() {
		this.okno = new JDialog(this.zarzadca.zwroc_glowne_okno(),"Edytuj dane");
		this.okno.setLayout(new GridLayout(8,2));
		
		JLabel text = new JLabel("Liczba testowych ramek:", JLabel.RIGHT);
		this.okno.add(text);
		this.pole_ramek_testowych = new JTextField(new Integer(this.zarzadca.jaka_liczba_ramek_testowych()).toString());
		this.pole_ramek_testowych.setName("ramki_testowe");
		this.pole_ramek_testowych.addFocusListener(this);
		this.okno.add(this.pole_ramek_testowych);
		
		text = new JLabel("BER:", JLabel.RIGHT);
		this.okno.add(text);
		this.pole_ber = new JTextField(new Double(this.zarzadca.jaki_ber()).toString());
		this.pole_ber.setName("ber");
		this.pole_ber.addFocusListener(this);
		this.okno.add(this.pole_ber);
		
		text = new JLabel("Liczba stanw przedalarmowych:", JLabel.RIGHT);
		this.okno.add(text);
		this.pole_stanow_przedalarmowych = new JTextField(new Integer(this.zarzadca.jaka_liczba_stanow_przedalarmowych()).toString());
		this.pole_stanow_przedalarmowych.setName("stany_przedalarmowe");
		this.pole_stanow_przedalarmowych.addFocusListener(this);
		this.okno.add(this.pole_stanow_przedalarmowych);
		
		text = new JLabel("Liczba stanw potwierdzenia:", JLabel.RIGHT);
		this.okno.add(text);
		this.pole_stanow_potwierdzenia = new JTextField(new Integer(this.zarzadca.jaka_liczba_stanow_potwierdzenia()).toString());
		this.pole_stanow_potwierdzenia.setName("stany_potwierdzenia");
		this.pole_stanow_potwierdzenia.addFocusListener(this);
		this.okno.add(this.pole_stanow_potwierdzenia);
		
		if (this.czy_sdh == true) {
			text = new JLabel("Liczba bajtw synchronizacyjnych:", JLabel.RIGHT);
			this.okno.add(text);
			this.pole_bajtow_synchronizacyjnych = new JTextField(new Integer(this.zarzadca.jaka_liczba_bajtow_synchronizacyjnych()).toString());
			this.pole_bajtow_synchronizacyjnych.setName("bajty_synchronizacyjne");
			this.pole_bajtow_synchronizacyjnych.addFocusListener(this);
			this.okno.add(this.pole_bajtow_synchronizacyjnych);
		}
				
		text = new JLabel("Start od stanu:", JLabel.RIGHT);
		this.okno.add(text);
		JPanel poleRadio = new JPanel(new GridLayout(2,1));
		this.grupa_start = new ButtonGroup();
		JRadioButton radio = new JRadioButton("Synchronizacji");
		if(this.zarzadca.jaki_start() == true) {
			radio.setSelected(true);
		}
		radio.setActionCommand("tak");
		this.grupa_start.add(radio);
		poleRadio.add(radio);
		radio = new JRadioButton("Poszukiwania");
		if(this.zarzadca.jaki_start() == false) {
			radio.setSelected(true);
		}
		radio.setActionCommand("nie");
		this.grupa_start.add(radio);
		poleRadio.add(radio);
		this.okno.add(poleRadio);
		
		text = new JLabel("Dane uytkownika:", JLabel.RIGHT);
		this.okno.add(text);
		poleRadio = new JPanel(new GridLayout(2,1));
		this.grupa_losowosc_danych = new ButtonGroup();
		radio = new JRadioButton("losowe");
		if(this.zarzadca.jakie_dane_uzykownika() == true) {
			radio.setSelected(true);
		}
		radio.setActionCommand("tak");
		this.grupa_losowosc_danych.add(radio);
		poleRadio.add(radio);
		radio = new JRadioButton("nielosowe");
		if(this.zarzadca.jakie_dane_uzykownika() == false) {
			radio.setSelected(true);
		}
		radio.setActionCommand("nie");
		this.grupa_losowosc_danych.add(radio);
		poleRadio.add(radio);
		this.okno.add(poleRadio);
		
		if(this.czy_sdh == false) {
			text = new JLabel("Wzr symulowany:", JLabel.RIGHT);
			this.okno.add(text);
			poleRadio = new JPanel(new GridLayout(2,1));
			this.grupa_wzoru_symulowanego = new ButtonGroup();
			radio = new JRadioButton("tak");
			if(this.zarzadca.czy_wzor_jest_symulowany() == true) {
				radio.setSelected(true);
			}
			radio.setActionCommand("tak");
			this.grupa_wzoru_symulowanego.add(radio);
			poleRadio.add(radio);
			radio = new JRadioButton("nie");
			if(this.zarzadca.czy_wzor_jest_symulowany() == false) {
				radio.setSelected(true);
			}
			radio.setActionCommand("nie");
			this.grupa_wzoru_symulowanego.add(radio);
			poleRadio.add(radio);
			this.okno.add(poleRadio);
		}
		
		JButton przycisk = new JButton("Rezygnuj");
		przycisk.setActionCommand("DaneCancel");
		przycisk.addActionListener(this);
		this.okno.add(przycisk);
		przycisk = new JButton("Zatwierd");
		przycisk.setActionCommand("DaneOK");
		przycisk.addActionListener(this);
		this.okno.add(przycisk);

		this.okno.addWindowListener(this);
		
		this.okno.setSize(400,250);
		this.okno.setResizable(true);
		this.okno.setVisible(true);
	}
	
	private void zamykanie_bez_zapisu() {
		this.okno.setVisible(false);
		this.zarzadca.aktywuj_okno_glowne();
	}
	private boolean sprawdz_pole_ramek_testowych() {
		String tekst = this.pole_ramek_testowych.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 0 )  {//&& liczba <= OknoDane.MAX_liczba_ramek_testowych) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_stanow_potwierdzenia() {
		String tekst = this.pole_stanow_potwierdzenia.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (this.czy_sdh == true) {
				if (liczba >= 0 && liczba <= OknoDane.MAX_liczba_stanow_potwierdzenia) {
					return true;
				}
			}
			else {
				if (liczba >= OknoDane.MIN_liczba_stanow_potwierdzenia && liczba <= OknoDane.MAX_liczba_stanow_potwierdzenia) {
					return true;
				}
			}
			
		}
		return false;
	}
	private boolean sprawdz_pole_stanow_przedalaramowych() {
		String tekst = this.pole_stanow_przedalarmowych.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 0 && liczba <= OknoDane.MAX_liczba_stanow_przedalarmowych) {
					return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_ber() {
		String tekst = this.pole_ber.getText();
		if (Bajt.CzyJestDouble(tekst)==true) {
			double liczba = new Double(tekst).doubleValue();
			if (liczba >= 0 && liczba <= 1) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_bajty_synchronizacyjne() {
		String tekst = this.pole_bajtow_synchronizacyjnych.getText();
		if (Bajt.CzyJestShort(tekst)==true) {
			short liczba = new Short(tekst).shortValue();
			if (liczba >0 && liczba < 7) {
				return true;
			}
		}
		return false;
	}
	
	private boolean pobierz_czy_start_od_synchronizacji() {
		if("tak".equals(this.grupa_start.getSelection().getActionCommand())) {
			return true;
		}
		return false;
	}
	private boolean pobierz_czy_dane_losowe() {
		if("tak".equals(this.grupa_losowosc_danych.getSelection().getActionCommand())) {
			return true;
		}
		return false;
		
	}
	private boolean pobierz_czy_wzor_symulowany() {
		if("tak".equals(this.grupa_wzoru_symulowanego.getSelection().getActionCommand())) {
			return true;
		}
		return false;
		
	}
	public void actionPerformed(ActionEvent evt) {
		if("DaneCancel".equals(evt.getActionCommand())) {
			this.zamykanie_bez_zapisu();
		}
		if("DaneOK".equals(evt.getActionCommand())) {
			this.zarzadca.zmien_liczbe_ramek_testowych(Integer.parseInt(this.pole_ramek_testowych.getText()));
			this.zarzadca.zmien_liczbe_stanow_potwierdzenia(Integer.parseInt(this.pole_stanow_potwierdzenia.getText()));
			this.zarzadca.zmien_liczbe_stanow_przedalarmowych(Integer.parseInt(this.pole_stanow_przedalarmowych.getText()));
			this.zarzadca.zmien_ber(Double.parseDouble(this.pole_ber.getText()));
			if(this.czy_sdh == true) {
				this.zarzadca.zmien_liczbe_bajtow_synchronizacyjnych(Short.parseShort(this.pole_bajtow_synchronizacyjnych.getText()));
			}
			if(this.pobierz_czy_start_od_synchronizacji() == true) {
				this.zarzadca.zacznij_od_stanu_synchronizacji();
			}
			else {
				this.zarzadca.zacznij_od_stanu_poszukiwania();
			}
			if(this.pobierz_czy_dane_losowe() == true) {
				this.zarzadca.ustaw_dane_uzytkownika_na_losowe();
			}
			else {
				this.zarzadca.ustaw_dane_uzytkownika_na_nielosowe();
			}
			if(this.czy_sdh == false) {
				if(this.pobierz_czy_wzor_symulowany() == true) {
					this.zarzadca.ustaw_aby_byl_wzor_symulowany();
				}
				else {
					this.zarzadca.ustaw_aby_nie_bylo_wzoru_symulowanego();
				}
			}
			this.okno.setVisible(false);
			if(this.czy_sdh == true) {
				this.zarzadca.wstaw_zakladke_z_danymiSDH();
			}
			else {
				this.zarzadca.wstaw_zakladke_z_danymiPCM();
			}
			this.zarzadca.aktywuj_okno_glowne();
		}
		
	}

	public void focusLost(FocusEvent evt) {
		if("ramki_testowe".equals(evt.getComponent().getName())) {
			//sprawdzenie pola ramek testowych
			if (this.sprawdz_pole_ramek_testowych()==false) {
				String komunikat ="Pole ramek testowych moe zawiera tylko liczb";// w zakresie <0, " + OknoDane.MAX_liczba_ramek_testowych + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_ramek_testowych.setText(new Integer(this.zarzadca.jaka_liczba_ramek_testowych()).toString());
				this.pole_ramek_testowych.grabFocus();
			}
			
		}
		if("stany_potwierdzenia".equals(evt.getComponent().getName())) {
			//sprawdzenie pola stanow potwierdzenia
			if (this.sprawdz_pole_stanow_potwierdzenia()==false) {
				String komunikat ="Pole stanw potwierdzenia moe zawiera\n" +
						"tylko liczb w zakresie ";
				if(this.czy_sdh == true) {
					komunikat += "<0, " + OknoDane.MAX_liczba_stanow_potwierdzenia + ">.";
				}
				else {
					komunikat += "<" + OknoDane.MIN_liczba_stanow_potwierdzenia + ", " + OknoDane.MAX_liczba_stanow_potwierdzenia + ">.";
				}
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_stanow_potwierdzenia.setText(new Integer(this.zarzadca.jaka_liczba_stanow_potwierdzenia()).toString());
				this.pole_stanow_potwierdzenia.grabFocus();
			}
		}
		if("stany_przedalarmowe".equals(evt.getComponent().getName())) {
			//sprawdzenie pola stanow przedalarmowych
			if (this.sprawdz_pole_stanow_przedalaramowych()==false) {
				String komunikat ="Pole stanw przedalarmowych moe zawiera\n" + 
						"tylko liczb w zakresie <0, " + OknoDane.MAX_liczba_stanow_przedalarmowych + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_stanow_przedalarmowych.setText(new Integer(this.zarzadca.jaka_liczba_stanow_przedalarmowych()).toString());
				this.pole_stanow_przedalarmowych.grabFocus();
			}
		}
		if("ber".equals(evt.getComponent().getName())) {
			//sprawdzenie pola ber
			if (this.sprawdz_pole_ber()==false) {
				String komunikat ="Pole BER moe zawiera tylko liczb w zakresie <0, 1>.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_ber.setText(new Double(this.zarzadca.jaki_ber()).toString());
				this.pole_ber.grabFocus();
			}
		}
		if("bajty_synchronizacyjne".equals(evt.getComponent().getName())) {
			//sprawdzenie pola bajtow synchronizacyjnych
			if (this.sprawdz_pole_bajty_synchronizacyjne()==false) {
				String komunikat ="Pole bajtw synchronizacyjnych moe zawiera\n" +
				"tylko liczb w zakresie <1, " + OknoDane.MAX_liczba_bajtow_synchronizacyjnych +">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_bajtow_synchronizacyjnych.setText(new Short(this.zarzadca.jaka_liczba_bajtow_synchronizacyjnych()).toString());
				this.pole_bajtow_synchronizacyjnych.grabFocus();
			}
		}
		
	}
	public void okno_dla_sdh() {
		this.czy_sdh = true;
	}
	public void okno_dla_pcm() {
		this.czy_sdh = false;
	}
	public void focusGained(FocusEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosing(WindowEvent arg0) {
		this.zamykanie_bez_zapisu();
		
	}

	public void windowOpened(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosed(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowIconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeiconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowActivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeactivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
}
