package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import pcm.BadaniePanelPCM;
import podstawy.Monitor;

import rozproszony.BadaniePanelROZP;
import rozproszony.DanePanelRozpr;
import rozproszony.Obliczenia;
import rozproszony.OknoDaneRozpr;
import rozproszony.WartosciPanel;
import rozproszony.WykresPanel;
import rozproszony.WynikiPanel;
import sdh.BadaniePanel;


public class Gui implements ActionListener, ChangeListener {

	private JFrame okno;
	private JTabbedPane tabpanel;
	
	private Monitor monitor;
	private int liczba_ramek_testowych = 10000;
	private int liczba_stanow_przedalarmowych = 2;
	private int liczba_stanow_potwierdzenia = 2;
	private double ber = 0.01;
	private boolean start_od_synchronizacji = true;
	private boolean dane_uzytkownika_losowe = true;
	private short liczba_bajtow_synchronizacyjnych = 6;
	private boolean wzor_symulowany = false;
	private boolean czy_sdh;
	private boolean trwa_badanie = false;
	
	private int dlugosc_ramki = 60;
	private int bufor_poszukiwania = 10;
	private int bufor_synchronizacji = 10;
	private int prog_synchronizacji=10;
	
	public Gui() {
		this.init();
	}
	public void init() {
		okno = new JFrame("Synchronizacja - Laboratorium");
		okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		try {
		ImageIcon icon = Gui.createImageIcon("rysunki/syn.png");
		this.okno.setIconImage(icon.getImage());
		}catch(NullPointerException exp) {
			System.out.println("Bez rysunku: rysunki/syn.png");
		}
		JMenuBar menuGlowne = new JMenuBar();
		//system PCM
		JMenu system = new JMenu("System PCM");
		JMenuItem dane = new JMenuItem("Edytuj dane");
		dane.setActionCommand("edytujDanePCM");
		dane.addActionListener(this);
		JMenuItem start = new JMenuItem("Start symulacji");
		start.setActionCommand("startPCM");
		start.addActionListener(this);
		JMenuItem statystyka = new JMenuItem("Statystyka badania");
		statystyka.setActionCommand("statystykaPCM");
		statystyka.addActionListener(this);
		system.add(dane);
		system.add(start);
		system.add(statystyka);
		menuGlowne.add(system);
		//system SDH
		system = new JMenu("System SDH");
		dane = new JMenuItem("Edytuj dane");
		dane.setActionCommand("edytujDaneSDH");
		dane.addActionListener(this);
		start = new JMenuItem("Start symulacji");
		start.setActionCommand("startSDH");
		start.addActionListener(this);
		statystyka = new JMenuItem("Statystyka badania");
		statystyka.setActionCommand("statystykaSDH");
		statystyka.addActionListener(this);
		system.add(dane);
		system.add(start);
		system.add(statystyka);
		menuGlowne.add(system);
		//synchronizacja rozproszona
		system = new JMenu("Rozproszony wzr");
		dane = new JMenuItem("Edytuj dane");
		dane.setActionCommand("edytujDaneROZPR");
		dane.addActionListener(this);
		start = new JMenuItem("Prezentacja wykresw");
		start.setActionCommand("wykresyROZPR");
		start.addActionListener(this);
		statystyka = new JMenuItem("Start symulacji");
		statystyka.setActionCommand("symulacjaROZPR");
		statystyka.addActionListener(this);
		system.add(dane);
		system.add(start);
		system.add(statystyka);
		menuGlowne.add(system);
		
		okno.setJMenuBar(menuGlowne);
		okno.setSize(500,500);
		okno.setResizable(true);
		okno.setVisible(true);
	}
	public void actionPerformed(ActionEvent evt) {
		if ("edytujDanePCM".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				//wywolanie okna edytowania dla pcm
				this.dezaktywuj_okno_glowne();
				new OknoDane(this, false);
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}			
		}
		if ("startPCM".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				//start badania PCM
				this.inicjuj_monitor();
				this.wstaw_zakladke_z_danymiPCM();
				BadaniePanelPCM badaniePanelpcm = new BadaniePanelPCM(this, this.monitor);
				try {
					ImageIcon icon = Gui.createImageIcon("rysunki/pcm.png");
					this.tabpanel.addTab("Symulacja",icon, badaniePanelpcm);
				}catch(NullPointerException exp) {
					this.tabpanel.addTab("Symulacja(PCM)", badaniePanelpcm);
				}
				this.tabpanel.addTab("Przyspiesz...", new JPanel());
				this.tabpanel.setName("Zakladki");
				this.tabpanel.addChangeListener(this);
				this.tabpanel.setSelectedIndex(this.tabpanel.indexOfTab("Symulacja"));
				this.okno.setVisible(true);
				this.czy_sdh = false;
				this.rozpoczeto_badanie();
				badaniePanelpcm.start();
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}		
			
		}
		if ("statystykaPCM".equals(evt.getActionCommand())) {
			//wywolanie okna wynikow badania
			if(this.trwa_badanie == false) {
				if(this.monitor != null && this.czy_sdh == false) {
					try {
						ImageIcon icon = Gui.createImageIcon("rysunki/pcm.png");
						if (tabpanel.indexOfTab("Symulacja") != -1) {
							if (tabpanel.indexOfTab("Statystyka") == -1) {
								tabpanel.addTab("Statystyka",icon, new StatPanel(this.monitor));
							}
						}
						else {
							tabpanel = new JTabbedPane();
							tabpanel.addTab("Dane wejciowe",icon, new DanePanel(this.monitor, false));
							tabpanel.addTab("Statystyka",icon, new StatPanel(this.monitor));
						}					
					}catch(NullPointerException exp) {
						if (tabpanel.indexOfTab("Symulacja") != -1) {
							if (tabpanel.indexOfTab("Statystyka") == -1) {
								tabpanel.addTab("Statystyka(PCM)",new StatPanel(this.monitor));
							}
						}
						else {
							tabpanel = new JTabbedPane();
							tabpanel.addTab("Dane wejciowe(PCM)", new DanePanel(this.monitor, false));
							tabpanel.addTab("Statystyka(PCM)", new StatPanel(this.monitor));
						}
					}
					
					
					tabpanel.setSelectedIndex(tabpanel.indexOfTab("Statystyka"));
					this.okno.setContentPane(tabpanel);
					this.okno.repaint();
				}
				else {
					String komunikat = "Na pocztku przeprowad badanie.";
					JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
				}
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}
			
		}
		if ("edytujDaneSDH".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				//wywolanie okna edytowania dla sdh
				this.dezaktywuj_okno_glowne();
				new OknoDane(this, true);
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}	
			
		}
		if ("startSDH".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				//start badania SDH
				this.inicjuj_monitor();
				this.wstaw_zakladke_z_danymiSDH();
				BadaniePanel badaniePanel = new BadaniePanel(this, this.monitor);
				try {
					ImageIcon icon = Gui.createImageIcon("rysunki/sdh.png");
					this.tabpanel.addTab("Symulacja",icon, badaniePanel);
				}catch(NullPointerException exp) {
					this.tabpanel.addTab("Symulacja(SDH)", badaniePanel);
				}
				this.tabpanel.addTab("Przyspiesz...", new JPanel());
				this.tabpanel.setName("Zakladki");
				this.tabpanel.addChangeListener(this);
				this.tabpanel.setSelectedIndex(this.tabpanel.indexOfTab("Symulacja"));
				this.okno.setVisible(true);
				this.czy_sdh = true;
				this.rozpoczeto_badanie();
				badaniePanel.start();
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}	
			
		}
		if ("statystykaSDH".equals(evt.getActionCommand())) {
			//wywolanie okna wynikow badania
			if(this.trwa_badanie == false) {
				if(this.monitor != null && this.czy_sdh == true) {
					try {
						ImageIcon icon = Gui.createImageIcon("rysunki/sdh.png");
						if (tabpanel.indexOfTab("Symulacja") != -1) {
							if(tabpanel.indexOfTab("Statystyka") == -1) {
								tabpanel.addTab("Statystyka",icon, new StatPanel(this.monitor));
							}
						}
						else {
							tabpanel = new JTabbedPane();
							tabpanel.addTab("Dane wejciowe",icon ,new DanePanel(this.monitor, true));
							tabpanel.addTab("Statystyka",icon, new StatPanel(this.monitor));
						}
					}catch(NullPointerException exp) {
						if (tabpanel.indexOfTab("Symulacja") != -1) {
							if(tabpanel.indexOfTab("Statystyka") == -1) {
								tabpanel.addTab("Statystyka(SDH)", new StatPanel(this.monitor));
							}
						}
						else {
							tabpanel = new JTabbedPane();
							tabpanel.addTab("Dane wejciowe(SDH)",new DanePanel(this.monitor, true));
							tabpanel.addTab("Statystyka(SDH)", new StatPanel(this.monitor));
						}
					}
					tabpanel.setSelectedIndex(tabpanel.indexOfTab("Statystyka"));
					this.okno.setContentPane(tabpanel);
					this.okno.repaint();
				}
				else {
					String komunikat = "Na pocztku przeprowad badanie.";
					JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
				}
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}
		}
		if ("edytujDaneROZPR".equals(evt.getActionCommand())) {
			//wywolanie okna edytowania dla synchronizacji rozporoszonej
			if(this.trwa_badanie == false) {
				this.dezaktywuj_okno_glowne();
				new OknoDaneRozpr(this);
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}
			
		}
		if ("wykresyROZPR".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				this.wstaw_zakladki_wykresowROZPR();
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}
		}
		if ("symulacjaROZPR".equals(evt.getActionCommand())) {
			if(this.trwa_badanie == false) {
				//start badania SDH
				this.inicjuj_monitor();
				this.wstaw_zakladke_z_danymiROZPR();
				BadaniePanelROZP badaniePanel = new BadaniePanelROZP(this, this.monitor);
				try {
					ImageIcon icon = Gui.createImageIcon("rysunki/roz.png");
					this.tabpanel.addTab("Symulacja",icon, badaniePanel);
				}catch(NullPointerException exp) {
					this.tabpanel.addTab("Symulacja(ROZP)", badaniePanel);
				}
				this.tabpanel.addTab("Przyspiesz...", new JPanel());
				this.tabpanel.setName("Zakladki");
				this.tabpanel.addChangeListener(this);
				this.tabpanel.setSelectedIndex(this.tabpanel.indexOfTab("Symulacja"));
				this.okno.setVisible(true);
				this.rozpoczeto_badanie();
				badaniePanel.start();
			}
			else {
				String komunikat = "Zaczekaj na zakoczenie badania.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd uytkownika", JOptionPane.ERROR_MESSAGE );
			}
		}
		
		
	}
	public void zmien_liczbe_ramek_testowych(int liczba) {
		this.liczba_ramek_testowych = liczba;
	}
	public int jaka_liczba_ramek_testowych() {
		return this.liczba_ramek_testowych;
	}
	public void zmien_liczbe_stanow_przedalarmowych(int liczba) {
		this.liczba_stanow_przedalarmowych = liczba;
	}
	public int jaka_liczba_stanow_przedalarmowych() {
		return this.liczba_stanow_przedalarmowych;
	}
	public void zmien_liczbe_stanow_potwierdzenia(int liczba) {
		this.liczba_stanow_potwierdzenia = liczba;
	}
	public int jaka_liczba_stanow_potwierdzenia() {
		return this.liczba_stanow_potwierdzenia;
	}
	public void zmien_ber(double b) {
		this.ber = b;
	}
	public double jaki_ber() {
		return this.ber;
	}
	public int jaka_dlugosc_ramki() {
		return this.dlugosc_ramki;
	}
	public void zmien_dlugosc_ramki(int liczba) {
		this.dlugosc_ramki = liczba;
	}
	public int jaki_bufor_poszukiwania() {
		return this.bufor_poszukiwania;
	}
	public void zmien_bufor_poszukiwania(int liczba) {
		this.bufor_poszukiwania = liczba;
	}
	public int jaki_bufor_synchronizacyjny() {
		return this.bufor_synchronizacji;
	}
	public void zmien_bufor_synchronizacji(int liczba) {
		this.bufor_synchronizacji = liczba;
	}
	public int jaki_prog_synchronizacji() {
		return this.prog_synchronizacji;
	}
	public void zmien_prog_synchronizacji(int liczba) {
		this.prog_synchronizacji = liczba;
	}
	public void zacznij_od_stanu_synchronizacji() {
		this.start_od_synchronizacji = true;
	}
	public void zacznij_od_stanu_poszukiwania() {
		this.start_od_synchronizacji = false;
	}
	public boolean jaki_start() {
		return this.start_od_synchronizacji;
	}
	public void ustaw_dane_uzytkownika_na_losowe() {
		this.dane_uzytkownika_losowe = true;
	}
	public void ustaw_dane_uzytkownika_na_nielosowe() {
		this.dane_uzytkownika_losowe = false;
	}
	public boolean jakie_dane_uzykownika() {
		return this.dane_uzytkownika_losowe;
	}
	public void zmien_liczbe_bajtow_synchronizacyjnych(short liczba) {
		this.liczba_bajtow_synchronizacyjnych = liczba;
	}
	public short jaka_liczba_bajtow_synchronizacyjnych() {
		return this.liczba_bajtow_synchronizacyjnych;
	}
	public void ustaw_aby_byl_wzor_symulowany() {
		this.wzor_symulowany = true;
	}
	public void ustaw_aby_nie_bylo_wzoru_symulowanego() {
		this.wzor_symulowany = false;
	}
	public boolean czy_wzor_jest_symulowany() {
		return this.wzor_symulowany;
	}
	public JFrame zwroc_glowne_okno() {
		return this.okno;
	}
	public void aktywuj_okno_glowne() {
		this.okno.setEnabled(true);
		this.okno.setVisible(true);
	}
	public void dezaktywuj_okno_glowne() {
		this.okno.setEnabled(false);
	}
	public void inicjuj_monitor() {
		this.monitor = new Monitor();
		this.monitor.dodaj_liczbe_ramek(this.liczba_ramek_testowych);
		this.monitor.dodaj_liczbe_stanow_przedalarmowych(this.liczba_stanow_przedalarmowych);
		this.monitor.dodaj_liczbe_stanow_potwierdzenia(this.liczba_stanow_potwierdzenia);
		this.monitor.dodaj_ber(this.ber);
		this.monitor.dodaj_liczbe_bajtow_synchronizacyjnych(this.liczba_bajtow_synchronizacyjnych);
		this.monitor.dodaj_wzor_symulowany(this.wzor_symulowany);
		this.monitor.dodaj_start_od_synchronizacji(this.start_od_synchronizacji);
		this.monitor.dodaj_dane_losowe(this.dane_uzytkownika_losowe);
		this.monitor.dodaj_dlugosc_ramki(this.dlugosc_ramki);
		this.monitor.dodaj_bufor_poszukiwania(this.bufor_poszukiwania);
		this.monitor.dodaj_bufor_synchronizacji(this.bufor_synchronizacji);
		this.monitor.dodaj_prog_synchronizacji(this.prog_synchronizacji);
		this.monitor.czysc_liste();
	}
	
	public synchronized void odswiez() {
		this.okno.repaint();
		this.okno.setVisible(true);
	}
	public void wstaw_zakladke_z_danymiSDH() {
		this.tabpanel = new JTabbedPane();
		DanePanel danepanel = new DanePanel();
		danepanel.wprowadzam_dane_sdh();
		danepanel.wstaw_liczbe_ramek(this.liczba_ramek_testowych);
		danepanel.wstaw_liczbe_stanow_przedalarmowych(this.liczba_stanow_przedalarmowych);
		danepanel.wstaw_liczbe_stanow_potwierdzenia(this.liczba_stanow_potwierdzenia);
		danepanel.wstaw_ber(this.ber);
		danepanel.wstaw_start_synchronizacji(this.start_od_synchronizacji);
		danepanel.wstaw_dane_losowe(this.dane_uzytkownika_losowe);
		danepanel.wstaw_liczbe_bajtow_synchronizacyjnych(this.liczba_bajtow_synchronizacyjnych);
		danepanel.organizuj();
		try {
			ImageIcon icon = Gui.createImageIcon("rysunki/sdh.png");
			this.tabpanel.addTab("Dane wejciowe",icon, danepanel);
		}catch(NullPointerException exp) {
			this.tabpanel.addTab("Dane wejciowe(SDH)", danepanel);
		}
		this.okno.setContentPane(tabpanel);
	}

	public void wstaw_zakladke_z_danymiPCM() {
		this.tabpanel = new JTabbedPane();
		DanePanel danepanel = new DanePanel();
		danepanel.wprowadzam_dane_pcm();
		danepanel.wstaw_liczbe_ramek(this.liczba_ramek_testowych);
		danepanel.wstaw_liczbe_stanow_przedalarmowych(this.liczba_stanow_przedalarmowych);
		danepanel.wstaw_liczbe_stanow_potwierdzenia(this.liczba_stanow_potwierdzenia);
		danepanel.wstaw_ber(this.ber);
		danepanel.wstaw_start_synchronizacji(this.start_od_synchronizacji);
		danepanel.wstaw_dane_losowe(this.dane_uzytkownika_losowe);
		danepanel.wstaw_wzor_symulowany(this.wzor_symulowany);
		danepanel.organizuj();
		try {
			ImageIcon icon = Gui.createImageIcon("rysunki/pcm.png");
			this.tabpanel.addTab("Dane wejciowe",icon, danepanel);
		}catch(NullPointerException exp) {
			this.tabpanel.addTab("Dane wejciowe(PCM)", danepanel);
		}
		this.okno.setContentPane(tabpanel);
	}
	public void wstaw_zakladke_z_danymiROZPR() {
		this.tabpanel = new JTabbedPane();
		this.wstaw_sama_zakladke_z_danymiROZPR();
		this.okno.setContentPane(tabpanel);
	}
	private void wstaw_sama_zakladke_z_danymiROZPR() {
		DanePanelRozpr danepanel = new DanePanelRozpr();
		danepanel.wstaw_dlugosc_ramki(this.dlugosc_ramki);
		danepanel.wstaw_bufor_poszukiwania(this.bufor_poszukiwania);
		danepanel.wstaw_bufor_synchronizacji(this.bufor_synchronizacji);
		danepanel.wstaw_prog_synchronizacji(this.prog_synchronizacji);
		danepanel.wstaw_prog_synchronizacji(this.prog_synchronizacji);
		danepanel.wstaw_ber(this.ber);
		danepanel.wstaw_liczbe_ramek_testowych(this.liczba_ramek_testowych);
		danepanel.wstaw_start_synchronizacji(this.start_od_synchronizacji);
		danepanel.wstaw_dane_losowe(this.dane_uzytkownika_losowe);
		danepanel.organizuj();
		try {
			ImageIcon icon = Gui.createImageIcon("rysunki/roz.png");
			this.tabpanel.addTab("Dane wejciowe",icon ,danepanel);
		}catch(NullPointerException exp) {
			this.tabpanel.addTab("Dane wejciowe(ROZP)",danepanel);
		}
	}
	public void wstaw_zakladki_wykresowROZPR() {
		Obliczenia obliczenia = new Obliczenia();
		obliczenia.wstaw_ber(this.ber);
		obliczenia.wstaw_dl_ramki(this.dlugosc_ramki);
		obliczenia.wstaw_bufor_poszukiwania(this.bufor_poszukiwania);
		obliczenia.wstaw_bufor_synchronizacji(this.bufor_synchronizacji);
		obliczenia.wstaw_prog_synchronizacji(this.prog_synchronizacji);
		obliczenia.wstaw_jakie_dane(this.dane_uzytkownika_losowe);
		obliczenia.oblicz_wszystko();
		this.tabpanel = new JTabbedPane();
		this.wstaw_sama_zakladke_z_danymiROZPR();
		WynikiPanel wynikipanel = new WynikiPanel(obliczenia);
		try {
			ImageIcon icon = Gui.createImageIcon("rysunki/roz.png");
			this.tabpanel.addTab("Wyniki oblicze",icon, wynikipanel);
			WartosciPanel wartoscipanel = new WartosciPanel(obliczenia);
			this.tabpanel.addTab("Wartoci do wykresw",icon, wartoscipanel);
			WykresPanel wykres = new WykresPanel(obliczenia.zwroc_Pgd_rowne_j(),obliczenia.zwroc_Pgs_rowne_j(),1);
			this.tabpanel.addTab("Poszukiwanie",icon, wykres);
			/*wykres = new WykresPanel(obliczenia.zwroc_Pdgd_wieksze_od_j(), obliczenia.zwroc_Pmax_gd(),2);
			this.tabpanel.addTab("Poszukiwanie 2",icon,wykres);*/
			wykres = new WykresPanel(obliczenia.zwroc_Pgd_rowne_jSYN(),obliczenia.zwroc_Pgs_rowne_jSYN(),1);
			this.tabpanel.addTab("Potwierdzenia",icon,wykres);
		}catch(NullPointerException exp) {
			this.tabpanel.addTab("Wyniki oblicze(ROZP)", wynikipanel);
			WartosciPanel wartoscipanel = new WartosciPanel(obliczenia);
			this.tabpanel.addTab("Wartoci do wykresw(ROZP)", wartoscipanel);
			WykresPanel wykres = new WykresPanel(obliczenia.zwroc_Pgd_rowne_j(),obliczenia.zwroc_Pgs_rowne_j(),1);
			this.tabpanel.addTab("Poszukiwanie 1(ROZP)", wykres);
			/*wykres = new WykresPanel(obliczenia.zwroc_Pdgd_wieksze_od_j(), obliczenia.zwroc_Pmax_gd(),2);
			this.tabpanel.addTab("Poszukiwanie 2(ROZP)",wykres);*/
			wykres = new WykresPanel(obliczenia.zwroc_Pgs_rowne_j(),obliczenia.zwroc_Pgd_rowne_j(),3);
			this.tabpanel.addTab("Potwierdzenia(ROZP)",wykres);
		}
		this.okno.setContentPane(tabpanel);
		this.okno.setVisible(true);
	}
	public void wstaw_zakladke_ze_statystykaROZPR() {
		try {
			ImageIcon icon = Gui.createImageIcon("rysunki/roz.png");
			tabpanel.addTab("Statystyka", icon,new StatPanel(this.monitor));
		}catch(NullPointerException exp) {
			tabpanel.addTab("Statystyka(ROZP)",new StatPanel(this.monitor));
		}
		this.okno.setContentPane(tabpanel);
	}
	public void rozpoczeto_badanie() {
		this.trwa_badanie = true;
	}
	public void zakonczono_badanie() {
		this.trwa_badanie = false;
	}
	/** Returns an ImageIcon, or null if the path was invalid. */
    public static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = Gui.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Nie mogem znale pliku: " + path);
            return null;
        }
    }
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new Gui();
	}
	public void stateChanged(ChangeEvent evt) {
		JTabbedPane temp = (JTabbedPane) evt.getSource();
		if ("Zakladki".equals(temp.getName())) {
			int idx = this.tabpanel.getSelectedIndex();
			String title = this.tabpanel.getTitleAt(idx);
			if("Przyspiesz...".equals(title)) {
				//System.out.println("Przejscie na przyspiesz");
				this.tabpanel.setSelectedIndex(0);
				this.tabpanel.remove(idx);
				this.odswiez();
			}
		}
	}

}
