package rozproszony;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JPanel;

public class WykresPanel extends JPanel{
	
	private Image rysunek;
	private ArrayList dane1;
	private ArrayList dane2;
	private double max=0;
	private int numer=1;
		
	public WykresPanel(ArrayList dane1, ArrayList dane2, int wart) {
		this.dane1 = dane1;
		this.dane2 = dane2;
		this.numer = wart;
		this.init();
	}
	private void init() {
		this.ustaw_maksa();
		this.repaint();
	}
	private void ustaw_maksa() {
		Iterator e = this.dane1.iterator();
		this.max = 0; 
		while(e.hasNext()) {
			this.max = Math.max(this.max, ((BigDecimal) e.next()).doubleValue());
		}
		e = this.dane2.iterator();
		while(e.hasNext()) {
			this.max = Math.max(this.max, ((BigDecimal) e.next()).doubleValue());
		}
	}
	private void rysuj(Graphics g, int W, int H) {
		int x =10;
		int y =20-3;
		int w = W-20;
		int h = (8*(H-40))/10+3;
		g.drawString("max: " + this.max, 5, 13);
		g.setColor(Color.WHITE);
		g.fillRect(x,y,w,h);
		g.setColor(Color.BLACK);
		g.drawRect(x,y,w,h);
		w=(W-20)/this.dane1.size();
		int j=0;
		int wys_poprzednia=0;
		Iterator e = this.dane1.iterator();
		while(e.hasNext()) {
			g.setColor(this.zwroc_kolor(true));
			//wykres 1 - linie poziome
			double pobrane = ((BigDecimal) e.next()).doubleValue();
			double wzgledna = (h-3)*pobrane/this.max;
			int wys = ((h-3)+20)-new Double(wzgledna).intValue();
			if(e.hasNext() != false) {
				g.fillRect(x+j*w, wys-3, w, 3);
			}
			else {
				g.fillRect(x+j*w, wys-3, (W-20)-j*w, 3);
				
			}
			//wykresu 1 - linie pionowe
			if(j!=0) {
				if (wys_poprzednia > wys) {
					g.fillRect(x+j*w, wys, 3, Math.abs(wys-wys_poprzednia));
				}
				else {
					g.fillRect(x+j*w, wys_poprzednia-3, 3, Math.abs(wys-wys_poprzednia));
				}
				
			}
			wys_poprzednia = wys;
			j++;

		}
		e = this.dane2.iterator();
		j=0;
		wys_poprzednia=0;
		while(e.hasNext()) {
			g.setColor(this.zwroc_kolor(false));
			//wykres 2 - linie poziome
			double pobrane = ((BigDecimal) e.next()).doubleValue();
			double wzgledna = (h-3)*pobrane/this.max;
			int wys = ((h-3)+20)-new Double(wzgledna).intValue();
			if(e.hasNext() != false) {
				g.fillRect(x+j*w, wys-3, w, 3);
			}
			else {
				g.fillRect(x+j*w, wys-3, (W-20)-j*w, 3);
				
			}
			//wykresu 2 - linie pionowe
			if(j!=0) {
				if (wys_poprzednia > wys) {
					g.fillRect(x+j*w, wys, 3, Math.abs(wys-wys_poprzednia));
				}
				else {
					g.fillRect(x+j*w, wys_poprzednia-3, 3, Math.abs(wys-wys_poprzednia));
				}
			}
			wys_poprzednia = wys;
			g.setColor(Color.BLACK);
			//rysowanie siatki wykresu
			g.drawLine(x+j*w, y, x+j*w, y+h);
			g.drawString("j=" + j, x+j*w+w/4, y+h-4);
			j++;
		}
		y=y+h+10;
		h=(2*(H-40))/10;
		w = W-20;
		g.drawRect(x,y,w,h);
		g.drawString("Legenda:", x+5, y+12);
		//Legenda
		h =((2*(H-40))/10 - 40)/2;
		y = y+20;
		x = x+5;
		w = (W-20)/15;
		g.setColor(Color.WHITE);
		g.fillRect(x,y, w,h);
		g.setColor(Color.BLACK);
		g.drawRect(x,y, w,h);
		g.drawString(this.zwroc_podpis(true), x+w+5, y+h/2);
		g.setColor(this.zwroc_kolor(true));
		g.fillRect(x, y+h/2, w, 3);
		
		g.setColor(Color.WHITE);
		g.fillRect(x,y+h+10, w,h);
		g.setColor(Color.BLACK);
		g.drawRect(x,y+h+10, w,h);
		g.drawString(this.zwroc_podpis(false), x+w+5, y+h+10+h/2);
		g.setColor(this.zwroc_kolor(false));
		g.fillRect(x, y+h+10+h/2, w, 3);
		
	}
	public void paint(Graphics g) {
		this.rysunek = this.createImage(this.getWidth(), this.getHeight());
		Graphics ekran = null;
		ekran = g;
		try {
			g = rysunek.getGraphics();
			this.rysuj(g,this.getWidth(), this.getHeight());
		}catch(NullPointerException blad) {
			System.out.println("Bad rysowania panelu badania");
		}
		ekran.drawImage(rysunek, 0,0, null);
		
		
	}
	private Color zwroc_kolor(boolean czyPierwszeDane) {
		switch(this.numer) {
		case 1: //poszukiwanie
			if (czyPierwszeDane == true) {
				//pojedyncze
				return Color.GREEN;
			}
			else {
				//sekewncja
				return Color.BLUE;
			}
		case 2: //poszukiwanie 2
			if (czyPierwszeDane == true) {
				//wieksze
				return Color.GREEN;
			}
			else {
				//max
				return Color.BLUE;
			}
		case 3: //potwierdzenia
			if (czyPierwszeDane == true) {
				//pojedyncze
				return  Color.ORANGE;
			}
			else {
				//sekewncja
				return Color.MAGENTA;
			}
		default:
			return Color.BLACK;
		}
	}

	private String zwroc_podpis(boolean czyPierwszeDane) {
		switch(this.numer) {
		case 1: //poszukiwanie
			if (czyPierwszeDane == true) {
				//pojedyncze
				return "P(g=j) dla pojedynczej sekwencji danych";
			}
			else {
				//sekewncja
				return "P(g=j) dla sekwencji synchronizacyjnej";
			}
		case 2: //poszukiwanie 2
			if (czyPierwszeDane == true) {
				//wieksze
				return "Prawdopodobiestwo e g wiksze lub rwne j dla sekwecji danych";
			}
			else {
				//max
				return "Prawdopodobiestwo e max g rwne j dla sekwencji danych";
			}
		case 3: //potwierdzenia
			if (czyPierwszeDane == true) {
				//pojedyncze
				return  "P(g=j) dla pojedynczej sekwencji danych";
			}
			else {
				//sekewncja
				return "P(g=j) dla sekwencji synchronizacyjnej";
			}
		default:
			return "Bd";
		}
	}

}
