package rozproszony;

import gui.Gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import podstawy.Bajt;

public class OknoDaneRozpr implements ActionListener, FocusListener, WindowListener {
	private static int MAX_dlugosc_ramki = 500;
	private static int MAX_dlugosc_bufora = 200;
	//private static int MAX_liczba_ramek_testowych = 50000;
	
	private Gui zarzadca;
	private JDialog okno;
	
	private JTextField pole_ramek_testowych;
	private JTextField pole_dlugosci_ramki;
	private JTextField pole_bufora_poszukiwania;
	private JTextField pole_bufora_synchronizacji;
	private JTextField pole_progu_synchronizacji;
	private JTextField pole_ber;
	private ButtonGroup grupa_start;
	private ButtonGroup grupa_losowosc_danych;
	
	public OknoDaneRozpr(Gui z) {
		this.zarzadca = z;
		this.init();
	}
	
	private void init() {
		this.okno = new JDialog(this.zarzadca.zwroc_glowne_okno(),"Edytuj dane");
		this.okno.setLayout(new GridLayout(4,1));
		
		JPanel panelglowny = new JPanel(new GridLayout(2,1));
		JPanel panel = new JPanel(new GridLayout(1,2));
		JLabel text = new JLabel("BER:", JLabel.RIGHT);
		panel.add(text);
		this.pole_ber = new JTextField(new Double(this.zarzadca.jaki_ber()).toString());
		this.pole_ber.setName("ber");
		this.pole_ber.addFocusListener(this);
		panel.add(this.pole_ber);
		panelglowny.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Dugo ramki:", JLabel.RIGHT);
		panel.add(text);
		this.pole_dlugosci_ramki = new JTextField(new Integer(this.zarzadca.jaka_dlugosc_ramki()).toString());
		this.pole_dlugosci_ramki.setName("dl_ramki");
		this.pole_dlugosci_ramki.addFocusListener(this);
		panel.add(this.pole_dlugosci_ramki);
		panelglowny.add(panel);
		this.okno.add(panelglowny);
		
		panel = new JPanel(new GridLayout(3,3));
		panel.add(new JLabel(""));
		text = new JLabel("Stan Synchronizacji", JLabel.CENTER);
		panel.add(text);
		text = new JLabel("Stan Poszukiwania", JLabel.CENTER);
		panel.add(text);
		text = new JLabel("Dugo bufora:", JLabel.RIGHT);
		panel.add(text);
		this.pole_bufora_synchronizacji = new JTextField(new Integer(this.zarzadca.jaki_bufor_synchronizacyjny()).toString());
		this.pole_bufora_synchronizacji.setName("dl_bufora_syn");
		this.pole_bufora_synchronizacji.addFocusListener(this);
		panel.add(this.pole_bufora_synchronizacji);
		this.pole_bufora_poszukiwania = new JTextField(new Integer(this.zarzadca.jaki_bufor_poszukiwania()).toString());
		this.pole_bufora_poszukiwania.setName("dl_bufora_pos");
		this.pole_bufora_poszukiwania.addFocusListener(this);
		panel.add(this.pole_bufora_poszukiwania);
		text = new JLabel("Prg:", JLabel.RIGHT);
		panel.add(text);
		this.pole_progu_synchronizacji = new JTextField(new Integer(this.zarzadca.jaki_prog_synchronizacji()).toString());
		this.pole_progu_synchronizacji.setName("prog_syn");
		this.pole_progu_synchronizacji.addFocusListener(this);
		panel.add(this.pole_progu_synchronizacji);
		text = new JLabel("max", JLabel.CENTER);
		panel.add(text);
		this.okno.add(panel);

		panelglowny = new JPanel(new GridLayout(2,1));
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Liczba testowych ramek:", JLabel.RIGHT);
		panel.add(text);
		this.pole_ramek_testowych = new JTextField(new Integer(this.zarzadca.jaka_liczba_ramek_testowych()).toString());
		this.pole_ramek_testowych.setName("ramki_testowe");
		this.pole_ramek_testowych.addFocusListener(this);
		panel.add(this.pole_ramek_testowych);
		panelglowny.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Start Start od stanu:", JLabel.RIGHT);
		panel.add(text);
		JPanel poleRadio = new JPanel(new GridLayout(2,1));
		this.grupa_start = new ButtonGroup();
		JRadioButton radio = new JRadioButton("Synchronizacji");
		if(this.zarzadca.jaki_start() == true) {
			radio.setSelected(true);
		}
		radio.setActionCommand("tak");
		this.grupa_start.add(radio);
		poleRadio.add(radio);
		radio = new JRadioButton("Poszukiwania");
		if(this.zarzadca.jaki_start() == false) {
			radio.setSelected(true);
		}
		radio.setActionCommand("nie");
		this.grupa_start.add(radio);
		poleRadio.add(radio);
		panel.add(poleRadio);
		panelglowny.add(panel);
		this.okno.add(panelglowny);
		
		panelglowny = new JPanel(new GridLayout(2,1));
		panel = new JPanel(new GridLayout(1,2));
		text = new JLabel("Dane uytkownika:", JLabel.RIGHT);
		panel.add(text);
		poleRadio = new JPanel(new GridLayout(2,1));
		this.grupa_losowosc_danych = new ButtonGroup();
		radio = new JRadioButton("losowe");
		if(this.zarzadca.jakie_dane_uzykownika() == true) {
			radio.setSelected(true);
		}
		radio.setActionCommand("tak");
		this.grupa_losowosc_danych.add(radio);
		poleRadio.add(radio);
		radio = new JRadioButton("nielosowe");
		if(this.zarzadca.jakie_dane_uzykownika() == false) {
			radio.setSelected(true);
		}
		radio.setActionCommand("nie");
		this.grupa_losowosc_danych.add(radio);
		poleRadio.add(radio);
		panel.add(poleRadio);
		panelglowny.add(panel);
		
		panel = new JPanel(new GridLayout(1,2));
		JButton przycisk = new JButton("Rezygnuj");
		przycisk.setActionCommand("DaneCancel");
		przycisk.addActionListener(this);
		panel.add(przycisk);
		przycisk = new JButton("Zatwierd");
		przycisk.setActionCommand("DaneOK");
		przycisk.addActionListener(this);
		panel.add(przycisk);
		panelglowny.add(panel);
		this.okno.add(panelglowny);
		
		this.okno.addWindowListener(this);
		
		this.okno.setSize(400,250);
		this.okno.setResizable(true);
		this.okno.setVisible(true);
	}
	
	private void zamykanie_bez_zapisu() {
		this.okno.setVisible(false);
		this.zarzadca.aktywuj_okno_glowne();
	}
	private boolean sprawdz_pole_dlugosci_ramki() {
		String tekst = this.pole_dlugosci_ramki.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 1 && liczba <= OknoDaneRozpr.MAX_dlugosc_ramki) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_bufora_synchronizacji() {
		String tekst = this.pole_bufora_synchronizacji.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 1 && liczba <= OknoDaneRozpr.MAX_dlugosc_bufora) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_bufora_poszukiwania() {
		String tekst = this.pole_bufora_poszukiwania.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 1 && liczba <= OknoDaneRozpr.MAX_dlugosc_bufora) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_progu_synchronizacji() {
		String tekst = this.pole_progu_synchronizacji.getText();
		String bufor = this.pole_bufora_synchronizacji.getText();
		int dl_buforu = 0;
		if(Bajt.CzyJestInt(bufor)==true) {
			dl_buforu = new Integer(bufor).intValue();
		}
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba >= 1 && liczba <= dl_buforu) {
					return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_ber() {
		String tekst = this.pole_ber.getText();
		if (Bajt.CzyJestDouble(tekst)==true) {
			double liczba = new Double(tekst).doubleValue();
			if (liczba >= 0 && liczba <= 1) {
				return true;
			}
		}
		return false;
	}
	private boolean sprawdz_pole_ramek_testowych() {
		String tekst = this.pole_ramek_testowych.getText();
		if (Bajt.CzyJestInt(tekst)==true) {
			int liczba = new Integer(tekst).intValue();
			if (liczba > 0 ) {
				return true;
			}
		}
		return false;
	}
	
	private boolean pobierz_czy_start_od_synchronizacji() {
		if("tak".equals(this.grupa_start.getSelection().getActionCommand())) {
			return true;
		}
		return false;
	}
	private boolean pobierz_czy_dane_losowe() {
		if("tak".equals(this.grupa_losowosc_danych.getSelection().getActionCommand())) {
			return true;
		}
		return false;
		
	}
	
	public void actionPerformed(ActionEvent evt) {
		if("DaneCancel".equals(evt.getActionCommand())) {
			this.zamykanie_bez_zapisu();
		}
		if("DaneOK".equals(evt.getActionCommand())) {
			this.zarzadca.zmien_dlugosc_ramki(Integer.parseInt(this.pole_dlugosci_ramki.getText()));
			this.zarzadca.zmien_bufor_poszukiwania(Integer.parseInt(this.pole_bufora_poszukiwania.getText()));
			this.zarzadca.zmien_bufor_synchronizacji(Integer.parseInt(this.pole_bufora_synchronizacji.getText()));
			this.zarzadca.zmien_prog_synchronizacji(Integer.parseInt(this.pole_progu_synchronizacji.getText()));
			this.zarzadca.zmien_liczbe_ramek_testowych(Integer.parseInt(this.pole_ramek_testowych.getText()));
			this.zarzadca.zmien_ber(Double.parseDouble(this.pole_ber.getText()));
			
			if(this.pobierz_czy_start_od_synchronizacji() == true) {
				this.zarzadca.zacznij_od_stanu_synchronizacji();
			}
			else {
				this.zarzadca.zacznij_od_stanu_poszukiwania();
			}
			if(this.pobierz_czy_dane_losowe() == true) {
				this.zarzadca.ustaw_dane_uzytkownika_na_losowe();
			}
			else {
				this.zarzadca.ustaw_dane_uzytkownika_na_nielosowe();
			}
			this.okno.setVisible(false);
			//wstaw_zakadke
			this.zarzadca.wstaw_zakladke_z_danymiROZPR();
			this.zarzadca.aktywuj_okno_glowne();
		}
	}

	public void focusLost(FocusEvent evt) {
		if("dl_ramki".equals(evt.getComponent().getName())) {
			//sprawdzenie pola ramek testowych
			if (this.sprawdz_pole_dlugosci_ramki()==false) {
				String komunikat ="Pole dugoci ramki moe zawiera\n" + 
						"tylko liczb w zakresie <1, " + OknoDaneRozpr.MAX_dlugosc_ramki + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_dlugosci_ramki.setText(new Integer(this.zarzadca.jaka_dlugosc_ramki()).toString());
				this.pole_dlugosci_ramki.grabFocus();
			}
			
		}
		if("ramki_testowe".equals(evt.getComponent().getName())) {
			//sprawdzenie pola ramek testowych
			if (this.sprawdz_pole_ramek_testowych()==false) {
				String komunikat ="Pole ramek testowych moe zawiera tylko liczb";// w zakresie <0, " + OknoDaneRozpr.MAX_liczba_ramek_testowych + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_ramek_testowych.setText(new Integer(this.zarzadca.jaka_liczba_ramek_testowych()).toString());
				this.pole_ramek_testowych.grabFocus();
			}
			
		}
		if("dl_bufora_pos".equals(evt.getComponent().getName())) {
			//sprawdzenie pola stanow potwierdzenia
			if (this.sprawdz_pole_bufora_poszukiwania()==false) {
				String komunikat ="Pole dugoci bufora moe zawiera\n" +
						"tylko liczb w zakresie <1, " + OknoDaneRozpr.MAX_dlugosc_bufora + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_bufora_synchronizacji.setText(new Integer(this.zarzadca.jaki_bufor_poszukiwania()).toString());
				this.pole_bufora_synchronizacji.grabFocus();
			}
		}
		if("dl_bufora_syn".equals(evt.getComponent().getName())) {
			//sprawdzenie pola stanow potwierdzenia
			if (this.sprawdz_pole_bufora_synchronizacji()==false) {
				String komunikat ="Pole dugoci bufora moe zawiera\n" +
						"tylko liczb w zakresie <1, " + OknoDaneRozpr.MAX_dlugosc_bufora + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_bufora_synchronizacji.setText(new Integer(this.zarzadca.jaki_bufor_synchronizacyjny()).toString());
				this.pole_bufora_synchronizacji.grabFocus();
			}
			else {
				//sprawdzam czy prog nie jest wiekszy od bufora, jesli tak to go zmieniam
				String prog = this.pole_progu_synchronizacji.getText();
				int dl_progu = 0;
				if(Bajt.CzyJestInt(prog)==true) {
					dl_progu = new Integer(prog).intValue();
				}
				String bufor = this.pole_bufora_synchronizacji.getText();
				int dl_bufora = 0;
				if(Bajt.CzyJestInt(bufor)==true) {
					dl_bufora = new Integer(bufor).intValue();
				}
				if(dl_progu > dl_bufora) {
					this.pole_progu_synchronizacji.setText(new Integer(dl_bufora).toString());
				}
			}
		}
		if("prog_syn".equals(evt.getComponent().getName())) {
			String bufor = this.pole_bufora_synchronizacji.getText();
			int dl_bufora = 0;
			if(Bajt.CzyJestInt(bufor)==true) {
				dl_bufora = new Integer(bufor).intValue();
			}
			if (this.sprawdz_pole_progu_synchronizacji()==false) {
				String komunikat ="Pole progu moe zawiera\n" + 
						"tylko liczb w zakresie <1, " + dl_bufora + ">.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_progu_synchronizacji.setText(new Integer(this.zarzadca.jaki_prog_synchronizacji()).toString());
				this.pole_progu_synchronizacji.grabFocus();
			}
		}
		if("ber".equals(evt.getComponent().getName())) {
			//sprawdzenie pola ber
			if (this.sprawdz_pole_ber()==false) {
				String komunikat ="Pole BER moe zawiera tylko liczb w zakresie <0, 1>.";
				JOptionPane.showMessageDialog(this.okno, komunikat, "Bd danych", JOptionPane.ERROR_MESSAGE );
				this.pole_ber.setText(new Double(this.zarzadca.jaki_ber()).toString());
				this.pole_ber.grabFocus();
			}
		}
				
	}

	public void focusGained(FocusEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosing(WindowEvent arg0) {
		this.zamykanie_bez_zapisu();
		
	}

	public void windowOpened(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowClosed(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowIconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeiconified(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowActivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void windowDeactivated(WindowEvent arg0) {
		// TODO Auto-generated method stub
		
	}
}
