package rozproszony;

import gui.Gui;

import java.awt.Graphics;
import java.awt.Image;

import javax.swing.JOptionPane;
import javax.swing.JPanel;

import podstawy.Monitor;
import rozproszony.Odbiornik;

public class BadaniePanelROZP extends JPanel implements Runnable{

	private Thread watek;
	private Gui zarzadca;
	private Monitor monitor;
	private Odbiornik odbiornik;
	private Image rysunek;
	
	public BadaniePanelROZP(Gui z, Monitor m) {
		this.zarzadca = z;
		this.monitor = m;
		//System.out.println("Jestem w konstruktorze");
	}
	
	public void start() {
		watek = new Thread(this, "BadaniePanelROZP");
		this.watek.start();
	}
	public void run() {
		//System.out.println("Start");
		this.zarzadca.odswiez();
		this.rysunek = this.createImage(this.getWidth(), this.getHeight());
		Ramka ramka;
		this.odbiornik = new Odbiornik(this.zarzadca.jaki_bufor_poszukiwania(),this.zarzadca.jaki_bufor_synchronizacyjny(),this.zarzadca.jaki_prog_synchronizacji(),this.zarzadca.jaki_start());
		this.odbiornik.dodaj_monitor(monitor);
		int i=0;
		boolean czyJedynka = true;
		while(i< this.zarzadca.jaka_liczba_ramek_testowych()) {
			ramka = new Ramka(this.zarzadca.jaka_dlugosc_ramki(), czyJedynka, this.zarzadca.jakie_dane_uzykownika());
			ramka.przeklam_bajty_synchronizacyjne(this.zarzadca.jaki_ber());
			this.odbiornik.dodaj_ramke(ramka.zwroc_ramke());
			this.odbiornik.synchronizacja();
			this.repaint();
			try {
				Thread.sleep(0);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			czyJedynka = !czyJedynka;
			i++;
		}
		this.watek =null;
		this.zarzadca.zakonczono_badanie();
		JOptionPane.showMessageDialog(this.zarzadca.zwroc_glowne_okno(), "Badanie systemu z rozproszonym wzorem\nsynchronizacyjnym zakoczyo si.", "Powiadomienie", JOptionPane.INFORMATION_MESSAGE);
		//System.out.println("Koniec badania");
		this.zarzadca.wstaw_zakladke_ze_statystykaROZPR();
	}


	public void paint(Graphics g) {
		this.rysunek = this.createImage(this.getWidth(), this.getHeight());
		Graphics ekran = null;
		ekran = g;
		try {
			g = rysunek.getGraphics();
			this.odbiornik.rysuj(g, this.getWidth(), this.getHeight());
		}catch(NullPointerException blad) {
			System.out.println("Bad rysowania panelu badania");
		}
		ekran.drawImage(rysunek, 0,0, null);
	}
}
