package pcm;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

import podstawy.Bajt;
import podstawy.Monitor;
import podstawy.Stan;

public class Odbiornik{

	private ArrayList ramka = new ArrayList();
	
	private Stan synchronizacji;
	private Stan poszukiwania;
	private ArrayList przedalarmoweWzoru = new ArrayList();
	private ArrayList przedalarmoweBitu = new ArrayList();
	private ArrayList potwierdzajace = new ArrayList();
	private Stan opoznienia;
	
	private int pozycja = 1;
	private boolean parzystosc = true;
	private Monitor monitor;
	
	public Odbiornik(int liczba_przedalarmowe, int liczba_potwierdzenia, boolean startSynchronizacji) {
		this.synchronizacji = new Stan();
		this.poszukiwania = new Stan();
		for (int i=0; i < liczba_przedalarmowe; i++) {
			Stan temp = new Stan();
			this.przedalarmoweWzoru.add(temp);
			temp = new Stan();
			this.przedalarmoweBitu.add(temp);
		}
		for (int i=0; i < liczba_potwierdzenia; i++) {
			Stan temp = new Stan();
			this.potwierdzajace.add(temp);
		}
		this.opoznienia = new Stan();
		
		if (startSynchronizacji == true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
		this.oblicz_dzielnik_rysunkow();
		
	}
	public void dodaj_monitor(Monitor m) {
		this.monitor = m;
	}
	public void dodaj_ramke(ArrayList r) {
		this.ramka = r;
	}
	public void synchronizacja() {
//		sprawdzam stan przedalarmowy wzoru
		if (this.parzystosc == true && this.sprawdz_aktywnosc_alarmowychWzoru()) {
			this.dzialaj_przedalarmoweWzoru();
		}
		//sprawdzam stan przedalarmowy bitu
		else if (this.parzystosc == false && this.sprawdz_aktywnosc_alarmowychBitu()) {
			this.dzialaj_przedalarmoweBitu();
		}
		//sprawdzam stan synchronizacji
		else if (this.synchronizacji.jaka_aktywnosc()) {
			this.dzialaj_synchronizacja();
		}
		//sprawdzam stan poszukiwania
		else if (this.poszukiwania.jaka_aktywnosc()) {
			this.dzialaj_poszukiwania();
		}
		//sprawdzam stan potwierdzenia
		else if (this.sprawdz_aktywnosc_potwierdzajacych()) {
			this.dzialaj_potwierdzenia();
		}
		else if (this.opoznienia.jaka_aktywnosc()) {
			this.dzialaj_opoznienie();
		}
		else {
			System.out.println("Ze s warunki w synchronizacji");
		}
		this.parzystosc = !this.parzystosc;
	}

	/**
	 * Zwraca 7 bitw od danej pozycji
	 * @return
	 */
	private String przygotuj_bajty() {
		String bajty = "";
		if (this.pozycja <= 1) {
			Short temp = (Short) ramka.get(0);
			bajty = Bajt.zamien_na_String(temp.shortValue());
			bajty = bajty.substring(this.pozycja, this.pozycja + 7);
		}
		else {
			int poczatek = this.pozycja / 8;
			int reszta = this.pozycja % 8;
			if (reszta <=1) {
				Short temp = (Short) ramka.get(poczatek);
				bajty = Bajt.zamien_na_String(temp.shortValue());
				bajty = bajty.substring(reszta, reszta + 7);
			}
			else {
				Short temp = (Short) ramka.get(poczatek);
				String temp_bajty = Bajt.zamien_na_String(temp.shortValue());
				bajty = temp_bajty.substring(reszta);
				temp = (Short) ramka.get(poczatek+1);
				temp_bajty= Bajt.zamien_na_String(temp.shortValue());
				bajty += temp_bajty.substring(0, reszta-1);
			}
		}
		return bajty;
	}
	/*private void dzialaj_synchronizacja() {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("SYNF");
		}
		else {
			this.monitor.dodaj_zapis("SYNT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		if (this.parzystosc == true) {
			//sprawdzam wzor fazowania
			if ("0011011".equals(bajty_odebrane)) {
				this.synchronizacji.wlacz_aktywnosc();
			}
			else {
				if(this.przedalarmoweWzoru.isEmpty()) {
					this.poszukiwania.wlacz_aktywnosc();
				}
				else {
					Stan temp = (Stan) this.przedalarmoweWzoru.get(0);
					temp.wlacz_aktywnosc();
					this.przedalarmoweWzoru.set(0,temp);
				}
				this.synchronizacji.wylacz_aktywnosc();
			}
		}
		else {
			//sprawdzam bit fazowania
			bajty_odebrane = bajty_odebrane.substring(0,1);
			if ("1".equals(bajty_odebrane)) {
				this.synchronizacji.wlacz_aktywnosc();
			}
			else {
				if (this.przedalarmoweBitu.isEmpty()) {
					this.poszukiwania.wlacz_aktywnosc();
				}
				else {
					Stan temp = (Stan) this.przedalarmoweBitu.get(0);
					temp.wlacz_aktywnosc();
					this.przedalarmoweBitu.set(0,temp);
				}
				this.synchronizacji.wylacz_aktywnosc();
			}
		}
	}
	private void dzialaj_przedalarmoweWzoru(Iterator element) {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("ALRF");
		}
		else {
			this.monitor.dodaj_zapis("ALRT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		//((Stan) element).wylacz_aktywnosc();
		if ("0011011".equals(bajty_odebrane)== true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
			else {
				this.poszukiwania.wlacz_aktywnosc();
			}
		}
	}
	private void dzialaj_przedalarmoweBitu(Iterator element) {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("ALRF");
		}
		else {
			this.monitor.dodaj_zapis("ALRT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		bajty_odebrane = bajty_odebrane.substring(0,1);
		//((Stan) element).wylacz_aktywnosc();
		if ("1".equals(bajty_odebrane)== true) {
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
			else {
				this.poszukiwania.wlacz_aktywnosc();
			}
		}
	}
	private void dzialaj_poszukiwanie() {
		this.monitor.dodaj_zapis("POS");
		String bajty_odebrane ="";
		int poz=-1;
		bajty_odebrane ="";
		Iterator e = this.ramka.iterator();
		while(e.hasNext()) {
			Short temp  = (Short) e.next();
			bajty_odebrane += Bajt.zamien_na_String(temp.shortValue());
		}
		poz = bajty_odebrane.indexOf("0011011");
		if (poz != -1) {
			this.pozycja = poz;
			this.poszukiwania.wylacz_aktywnosc();
			this.parzystosc = true;
			Stan stan = (Stan) this.potwierdzajace.get(0);
			stan.wlacz_aktywnosc();
			this.potwierdzajace.set(0,stan);
		}
	}
	private void dzialaj_opoznienia() {
		this.monitor.dodaj_zapis("OPZ");
		this.opoznienia.wylacz_aktywnosc();
		this.poszukiwania.wlacz_aktywnosc();
	}
	private void dzialaj_potwierdzenia0(Iterator element) {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("POTF");
		}
		else {
			this.monitor.dodaj_zapis("POTT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		if ("0011011".equals(bajty_odebrane)) {
			this.opoznienia.wlacz_aktywnosc();
		}
		else {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
		}
	}
	private void dzialaj_potwierdzenia1(Iterator element) {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("POTF");
		}
		else {
			this.monitor.dodaj_zapis("POTT");
		}
		String bajty_odebrane = this.przygotuj_bajty();
		if ("0011011".equals(bajty_odebrane)) {
			if (element.hasNext()) {
				((Stan) element.next()).wlacz_aktywnosc();
			}
			else {
				this.synchronizacji.wlacz_aktywnosc();
			}
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
	}
	private void dzialaj_potwierdzenia(Iterator element) {
		if (this.pozycja != 1) {
			this.monitor.dodaj_zapis("POTF");
		}
		else {
			this.monitor.dodaj_zapis("POTT");
		}
		if (this.czy_spr_potwierdzenie == true) {
			String bajty_odebrane = this.przygotuj_bajty();
			if ("0011011".equals(bajty_odebrane)== false) {
				this.poszukiwania.wlacz_aktywnosc();
			}
			else {
				if (element.hasNext()) {
					((Stan) element.next()).wlacz_aktywnosc();
				}
				else {
					this.synchronizacji.wlacz_aktywnosc();
				}
			}
		}
		this.czy_spr_potwierdzenie = !this.czy_spr_potwierdzenie;
		
	}*/
	private boolean sprawdz_aktywnosc_alarmowychWzoru() {
		boolean aktywny = false;
		Iterator e = this.przedalarmoweWzoru.iterator();
		while (e.hasNext()) {
			boolean a =((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				aktywny = true;
				break;
			}
		}
		return aktywny;
	}
	/**
	 * Metoda zwraca numer aktywnego stanu w grupie stanw przedalarmowych
	 * poszukujacych wzoru synchroniazji
	 * @return numer aktywnego stanu
	 * 		   (-1 w przypadku gdy takiego stanu nie znalaz)
	 */
	private int ktory_aktywny_alarmowyWzoru() {
		int numer = -1;
		Iterator e = this.przedalarmoweWzoru.iterator();
		int i=0;
		while (e.hasNext()) {
			boolean a = ((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				numer = i;
				break;
			}
			i++;
		}
		return numer;
	}
	/**
	 * Metoda sprawdza czy ktry ze stanw przedalarmowych bitu jest aktywny
	 * @return true - jeli jeden ze stanw jest aktywny,
	 * 		   false - jeli aden ze stanw nie jest aktywny.
	 */
	private boolean sprawdz_aktywnosc_alarmowychBitu() {
		boolean aktywny = false;
		Iterator e = this.przedalarmoweBitu.iterator();
		while (e.hasNext()) {
			boolean a = ((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				aktywny = true;
				break;
			}
		}
		return aktywny;
	}
	/**
	 * Metoda zwraca numer aktywnego stanu w grupie stanw przedalarmowych
	 * poszukujacych bitu synchroniazji
	 * @return numer aktywnego stanu
	 * 		   (-1 w przypadku gdy takiego stanu nie znalaz)
	 */
	private int ktory_aktywny_alarmowyBitu() {
		int numer = -1;
		Iterator e = this.przedalarmoweBitu.iterator();
		int i=0;
		while (e.hasNext()) {
			boolean a = ((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				numer =i;
				break;
			}
			i++;
		}
		return numer;
	}
	/**
	 * Metoda sprawdza czy ktry ze stanw potwierdzenia jest aktywny
	 * @return true - jeli jeden ze stanw jest aktywny,
	 * 		   false - jeli aden ze stanw nie jest aktywny.
	 */
	private boolean sprawdz_aktywnosc_potwierdzajacych() {
		boolean aktywny = false;
		Iterator e = this.potwierdzajace.iterator();
		while (e.hasNext()) {
			boolean a = ((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				aktywny = true;
				break;
			}
		}
		return aktywny;
	}
	/**
	 * Metoda zwraca numer aktywnego stanu w grupie stanw potwierdzenia
	 * poszukujacych bitu synchroniazji
	 * @return numer aktywnego stanu
	 * 		   (-1 w przypadku gdy takiego stanu nie znalaz)
	 */
	private int ktory_aktywny_potwierdzajacy() {
		int numer = -1;
		Iterator e = this.potwierdzajace.iterator();
		int i = 0;
		while (e.hasNext()) {
			boolean a = ((Stan) e.next()).jaka_aktywnosc();
			if (a == true) {
				numer = i;
				break;
			}
			i++;
		}
		return numer;
	}
	/**
	 * Metoda ma za zadanie dezaktywowac stany przedalarmowe poszukujace
	 * bitu synchronizacji.
	 *
	 */
	private void dezaktywuj_stany_alarmoweBitu() {
		Iterator e = this.przedalarmoweBitu.iterator();
		while(e.hasNext()) {
			((Stan) e.next()).wylacz_aktywnosc();
		}
	}
	/**
	 * Metoda ma za zadanie dezaktywowac stany przedalarmowe poszukujace
	 * wzoru synchronizacji.
	 *
	 */
	private void dezaktywuj_stany_alarmoweWzoru() {
		Iterator e = this.przedalarmoweWzoru.iterator();
		while(e.hasNext()) {
			((Stan) e.next()).wylacz_aktywnosc();
		}
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan przedalarmowy wzoru jest aktywny
	 * @param ramka - bity ramki
	 */
	private void dzialaj_przedalarmoweWzoru() {
		String bitow7 = this.przygotuj_bajty();
		int nr = this.ktory_aktywny_alarmowyWzoru();
		//((Stan) this.przedalarmoweWzoru.get(nr)).wlacz_aktywnosc();
		this.monitor.dodaj_zapis("AW" + nr + this.OznaczeniePozycji());
		boolean spr = "0011011".equals(bitow7);
		if (spr == true) {
			//przechodze do stanu synchronizacji
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			if (this.przedalarmoweWzoru.size() > (nr+1)) {
				//przechodze do nastepnego stanu przedalarmowego wzoru
				((Stan) this.przedalarmoweWzoru.get(nr+1)).wlacz_aktywnosc();
			}
			else {
				//ostatni przechodze do stanu Poszukiwania
				this.poszukiwania.wlacz_aktywnosc();
				this.synchronizacji.wylacz_aktywnosc();
				this.dezaktywuj_stany_alarmoweBitu();
			}
		}
		((Stan) this.przedalarmoweWzoru.get(nr)).wylacz_aktywnosc();
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan przedalarmowy bitu jest aktywny
	 * @param ramka - bity ramki
	 */
	private void dzialaj_przedalarmoweBitu() {
		String bitow7 = this.przygotuj_bajty();
		int nr = this.ktory_aktywny_alarmowyBitu();
		//((Stan) this.przedalarmoweBitu.get(nr)).wlacz_aktywnosc();
		this.monitor.dodaj_zapis("AB" + nr + this.OznaczeniePozycji());
		bitow7 = bitow7.substring(0,1);
		boolean spr = "1".equals(bitow7);
		if (spr == true) {
			//przechodze do stanu synchronizacji
			this.synchronizacji.wlacz_aktywnosc();
		}
		else {
			if (this.przedalarmoweBitu.size() > (nr+1)) {
				((Stan) this.przedalarmoweBitu.get(nr+1)).wlacz_aktywnosc();
			}
			else {
				//ostatni przechodze do stanu Poszukiwania
				this.poszukiwania.wlacz_aktywnosc();
				this.synchronizacji.wlacz_aktywnosc();
				this.dezaktywuj_stany_alarmoweWzoru();
			}
		}
		((Stan) this.przedalarmoweBitu.get(nr)).wylacz_aktywnosc();
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan synchroniazacji jest aktywny
	 * @param ramka - bity ramki
	 */
	private void dzialaj_synchronizacja() {
		String bitow7 = this.przygotuj_bajty();
		//this.synchronizacji.wlacz_aktywnosc();
		this.monitor.dodaj_zapis("SYN" + this.OznaczeniePozycji());
		boolean spr;
		if (this.parzystosc == true) {
			spr = "0011011".equals(bitow7);
		}
		else {
			bitow7 = bitow7.substring(0,1);
			spr = "1".equals(bitow7);
		}
		if (spr == false) {
			if (this.parzystosc == true) {
				if (this.przedalarmoweWzoru.isEmpty() == false) {
					((Stan) this.przedalarmoweWzoru.get(0)).wlacz_aktywnosc();
					if (this.sprawdz_aktywnosc_alarmowychBitu()) {
						this.synchronizacji.wylacz_aktywnosc();
					}
				}
				else {
					this.synchronizacji.wylacz_aktywnosc();
					this.poszukiwania.wlacz_aktywnosc();
				}
			}
			else {
				if (this.przedalarmoweBitu.isEmpty() == false) {
					((Stan) this.przedalarmoweBitu.get(0)).wlacz_aktywnosc();
					if (this.sprawdz_aktywnosc_alarmowychWzoru()) {
						this.synchronizacji.wylacz_aktywnosc();
					}
				}
				else {
					this.synchronizacji.wylacz_aktywnosc();
					this.poszukiwania.wlacz_aktywnosc();
				}
			}
		}
		else {
			this.synchronizacji.wlacz_aktywnosc();
		}
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan poszukiwania jest aktywny
	 * @param ramka - bity ramki
	 */
	private void dzialaj_poszukiwania() {
		//this.poszukiwania.wlacz_aktywnosc();
		this.monitor.dodaj_zapis("POS");
		String bajty_odebrane ="";
		int poz=-1;
		bajty_odebrane ="";
		Iterator e = this.ramka.iterator();
		while(e.hasNext()) {
			Short temp  = (Short) e.next();
			bajty_odebrane += Bajt.zamien_na_String(temp.shortValue());
		}
		poz = bajty_odebrane.indexOf("0011011");
		if (poz != -1) {
			this.parzystosc = true;
			this.pozycja = poz;
			((Stan) this.potwierdzajace.get(0)).wlacz_aktywnosc();
			this.poszukiwania.wylacz_aktywnosc();
		}
		else {
			this.poszukiwania.wlacz_aktywnosc();
		}
		
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan potwierdzenia jest aktywny
	 * @param ramka - bity ramki
	 */
	private void dzialaj_potwierdzenia() {
		String bitow7 = this.przygotuj_bajty();
		int nr = this.ktory_aktywny_potwierdzajacy();
		//((Potwierdzenia) this.stanyPotwierdzenia.elementAt(nr)).zwiekszLiczbeRamek();
		this.monitor.dodaj_zapis("PT" + nr +""+ this.OznaczeniePozycji());
		if (nr == 0) {
			boolean spr = "0011011".equals(bitow7);
			if (spr == true) {
				//znalazlem wzor choc nie powinienem
				this.opoznienia.wlacz_aktywnosc();
				((Stan) this.potwierdzajace.get(nr)).wylacz_aktywnosc();
			}
			else {
				((Stan) this.potwierdzajace.get(nr+1)).wlacz_aktywnosc();
				((Stan) this.potwierdzajace.get(nr)).wylacz_aktywnosc();
			}
		}
		else {
			if (this.parzystosc == true) {
				boolean spr = "0011011".equals(bitow7);
				if (spr == true) {
					if (this.potwierdzajace.size() > (nr+1)) {
						((Stan) this.potwierdzajace.get(nr+1)).wlacz_aktywnosc();
						((Stan) this.potwierdzajace.get(nr)).wylacz_aktywnosc();
					}
					else {
						this.synchronizacji.wlacz_aktywnosc();
						((Stan) this.potwierdzajace.get(nr)).wylacz_aktywnosc();
					}
				}
				else {
					this.poszukiwania.wlacz_aktywnosc();
					((Stan) this.potwierdzajace.get(nr)).wylacz_aktywnosc();
				}
			}
			else {
				((Stan) this.potwierdzajace.get(nr)).wlacz_aktywnosc();
			}
		}
	}
	/**
	 * Metoda ma za zadanie wykonac odpowiednie dzialania gdy
	 * odczytywana jest ramka a stan opoznienia jest aktywny
	 */
	private void dzialaj_opoznienie() {
		//this.stanOpoznienia.zwiekszLiczbeRamek();
		this.monitor.dodaj_zapis("OPZ" + this.OznaczeniePozycji());
		//this.pozycja = -1;
		this.poszukiwania.wlacz_aktywnosc();
		this.opoznienia.wylacz_aktywnosc();
	}
	
	private String OznaczeniePozycji() {
		if (this.pozycja == -1 || this.pozycja == 1) {
			return "T";
		}
		else {
			return "F";
		}
	}
	private void oblicz_dzielnik_rysunkow() {
		this.dzielnik_do_rysunku = 4;
		int liczba_stanow_posrednich = Math.max(this.przedalarmoweWzoru.size(), this.potwierdzajace.size());
		liczba_stanow_posrednich = Math.max(liczba_stanow_posrednich, this.przedalarmoweBitu.size());
		if (liczba_stanow_posrednich == 1) {
			this.dzielnik_do_rysunku = 5;
		}
		else if(liczba_stanow_posrednich >= 2) {
			this.dzielnik_do_rysunku = 5+2*(liczba_stanow_posrednich-1);
		}
		
	}
	private int dzielnik_do_rysunku;
	public void rysuj(Graphics g, int W, int H) {
		int h = (H-20)/this.dzielnik_do_rysunku;
		int x=0;
		int y=0;
		Font czcionka = g.getFont();
		g.setFont(new Font(czcionka.getName(), Font.BOLD, czcionka.getSize()));
		//Rysuje stan Synchronizacji
		int liczba_odwiedzin = this.synchronizacji.zwroc_liczbe_odwiedzin();
		x= 10;
		y= 10;
		if (this.synchronizacji.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1, y-1, W-18, h+2);
		}
		g.setColor(new Color(238, 201, 0));
		g.fillRoundRect(x, y, W-20, h, 20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2,y+(h/2));
		
		//Rysuje stan Poszukiwania
		liczba_odwiedzin = this.poszukiwania.zwroc_liczbe_odwiedzin();
		y=H-20-h;
		if (this.poszukiwania.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1,y-1, W-18 ,h+2);
		}
		g.setColor(new Color(178, 223, 238));
		g.fillRoundRect(x,y, W-20 ,h,20,20 );
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/2, y+(h/2));
		
		//Rysuje stany przedalarmowe Wzoru
		Iterator e = this.przedalarmoweWzoru.iterator();
		y = 10;
		Stan temp;
		while(e.hasNext()) {
			y = y + 2*h;
			temp = (Stan) e.next();
			liczba_odwiedzin = temp.zwroc_liczbe_odwiedzin();
			if(temp.jaka_aktywnosc()) {
				g.setColor(Color.RED);
				g.fillRect(x-1, y-1,((W-20)/8)+2, h+2);
			}
			g.setColor(new Color(162, 205, 90));
			g.fillRoundRect(x, y, (W-20)/8, h, 20, 20);
			g.setColor(Color.BLACK);
			g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/16, y+(h/2));
			//Rysuje strzalke od stanu poprzedniego do obecnego
			g.drawLine(x+(W-20)/16, y-h, x+(W-20)/16, y);
			g.drawLine(x+(W-20)/16, y-h/2,x+(W-20)/16-2, y-h/2-4 );
			g.drawLine(x+(W-20)/16, y-h/2,x+(W-20)/16+2, y-h/2-4);
			//Rysuje strzalke od stanu przedalarmowego do stanu synchronizacji
			g.drawLine(x+(W-20)/8, y+h/2, x+(W-20)/8+(W-20)/16, y+h/2);
			g.drawLine(x+(W-20)/8+(W-20)/16, y+h/2, x+(W-20)/8+(W-20)/16, 10+h);
			g.drawLine(x+(W-20)/8+(W-20)/16, y, x+(W-20)/8+(W-20)/16-2, y+4);
			g.drawLine(x+(W-20)/8+(W-20)/16, y, x+(W-20)/8+(W-20)/16+2, y+4);
		}
		//Rysuje strzalke koncowa od stanu przedalarmowego Wzoru do poszukiwania
		g.drawLine(x+(W-20)/16, y+h,x+(W-20)/16, H-20-h);
		g.drawLine(x+(W-20)/16, y+h+h/2, x+(W-20)/16-2, y+h+h/2-4);
		g.drawLine(x+(W-20)/16, y+h+h/2, x+(W-20)/16+2, y+h+h/2-4);
		
		//Rysuje stany przedalarmowe Bitu
		e = this.przedalarmoweBitu.iterator();
		y = 10;
		x = ((W-20)/8)*2;
		while(e.hasNext()) {
			y = y + 2*h;
			temp = (Stan) e.next();
			liczba_odwiedzin = temp.zwroc_liczbe_odwiedzin();
			if(temp.jaka_aktywnosc()) {
				g.setColor(Color.RED);
				g.fillRect(x-1, y-1,((W-20)/8)+2, h+2);
			}
			g.setColor(new Color(188, 238, 104));
			g.fillRoundRect(x, y, (W-20)/8, h, 20, 20);
			g.setColor(Color.BLACK);
			g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/16, y+(h/2));
			//Rysuje strzalke od stanu poprzedniego do obecnego
			g.drawLine(x+(W-20)/16, y-h, x+(W-20)/16, y);
			g.drawLine(x+(W-20)/16, y-h/2,x+(W-20)/16-2, y-h/2-4 );
			g.drawLine(x+(W-20)/16, y-h/2,x+(W-20)/16+2, y-h/2-4);
			//Rysuje strzalke od stanu przedalarmowego do stanu synchronizacji
			g.drawLine(x+(W-20)/8, y+h/2, x+(W-20)/8+(W-20)/16, y+h/2);
			g.drawLine(x+(W-20)/8+(W-20)/16, y+h/2, x+(W-20)/8+(W-20)/16, 10+h);
			g.drawLine(x+(W-20)/8+(W-20)/16, y, x+(W-20)/8+(W-20)/16-2, y+4);
			g.drawLine(x+(W-20)/8+(W-20)/16, y, x+(W-20)/8+(W-20)/16+2, y+4);
		}
		//Rysuje strzalke koncowa od stanu przedalarmowego Wzoru do poszukiwania
		g.drawLine(x+(W-20)/16, y+h,x+(W-20)/16, H-20-h);
		g.drawLine(x+(W-20)/16, y+h+h/2, x+(W-20)/16-2, y+h+h/2-4);
		g.drawLine(x+(W-20)/16, y+h+h/2, x+(W-20)/16+2, y+h+h/2-4);
		
		//Rysuje stany potwierdzenia
		e = this.potwierdzajace.iterator();
		x=5*((W-20)/8);
		y=H-20-h;
		int i=0;
		while(e.hasNext()) {
			y = y - 2*h;
			temp = (Stan) e.next();
			liczba_odwiedzin = temp.zwroc_liczbe_odwiedzin();
			if(temp.jaka_aktywnosc()) {
				g.setColor(Color.RED);
				g.fillRect(x-1, y-1,((W-20)/8)+2, h+2);
			}
			g.setColor(new Color(205,193,197));
			g.fillRoundRect(x, y, (W-20)/8, h, 20, 20);
			g.setColor(Color.BLACK);
			g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/16, y+(h/2));
			//Rysuje strzalke od stanu poprzedniego do stanu obecnego
			g.drawLine(x+(W-20)/16, y+2*h, x+(W-20)/16, y+h);
			g.drawLine(x+(W-20)/16, y+(2*h)-(h/2),x+(W-20)/16+2, y+(2*h)-(h/2)+4);
			g.drawLine(x+(W-20)/16, y+(2*h)-(h/2),x+(W-20)/16-2, y+(2*h)-(h/2)+4);
			if(i!=0) { 
				//Rysuje strzalki powrotne do stanu poszukiwania
				g.drawLine(x, y+h/2, x-(W-20)/16, y+h/2);
				g.drawLine(x-(W-20)/16, y+h/2, x-(W-20)/16, H-20-h);
				g.drawLine(x-(W-20)/16, y+h, x-(W-20)/16-2,y+h-4);
				g.drawLine(x-(W-20)/16, y+h, x-(W-20)/16+2,y+h-4);
			}
			i++;
		}
		//koncowa strzalka od stanu potwierdzenia
		g.drawLine(x+(W-20)/16, y, x+(W-20)/16, 10+h);
		g.drawLine(x+(W-20)/16, y-(h/2),x+(W-20)/16+2, y-(h/2)+4);
		g.drawLine(x+(W-20)/16, y-(h/2),x+(W-20)/16-2, y-(h/2)+4);
		
		//Rysuje stan opoznienia
		x=13*((W-20)/16);
		y=H-20-3*h;
		liczba_odwiedzin = this.opoznienia.zwroc_liczbe_odwiedzin();
		if(this.opoznienia.jaka_aktywnosc()) {
			g.setColor(Color.RED);
			g.fillRect(x-1, y-1,((W-20)/8)+2, h+2);
		}
		g.setColor(new Color(238, 213, 210));
		g.fillRoundRect(x, y, (W-20)/8, h, 20, 20);
		g.setColor(Color.BLACK);
		g.drawString(new Integer(liczba_odwiedzin).toString(), x+(W-20)/16, y+(h/2));
		//Rysuje strzalke od stanu potwierdzajacego do stanu opoznienia
		g.drawLine(x, y+h/2, 5*((W-20)/8)+(W-20)/8, y+h/2);
		g.drawLine(x-(W-20)/32, y+h/2,x-(W-20)/32-4, y+h/2-2);
		g.drawLine(x-(W-20)/32, y+h/2,x-(W-20)/32-4, y+h/2+2);
		//Rysuje strzalki powrotne do stanu poszukiwania
		g.drawLine(x+(W-20)/8, y+h/2, x+(W-20)/8+(W-20)/16, y+h/2);
		g.drawLine(x+(W-20)/8+(W-20)/16, y+h/2, x+(W-20)/8+(W-20)/16, H-20-h);
		g.drawLine(x+(W-20)/8+(W-20)/16, y+h, x+(W-20)/8+(W-20)/16-2,y+h-4);
		g.drawLine(x+(W-20)/8+(W-20)/16, y+h, x+(W-20)/8+(W-20)/16+2,y+h-4);
		
	}

}

