package gui;

import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

import podstawy.Monitor;


public class DanePanel extends JPanel {
	
	private int liczba_ramek;
	private int liczba_stanow_przedalarmowych;
	private int liczba_stanow_potwierdzenia;
	private short liczba_bajtow_synchronizacyjnach;
	private double ber;
	private boolean start_od_synchronizacji;
	private boolean dane_losowe;
	private boolean wzor_symulowany;
	private boolean czy_sdh;
	
	public DanePanel(Monitor m, boolean jakie) {
		this.czy_sdh = jakie;
		this.pobierz_dane_z_monitora(m);
		this.init();
	}
	public DanePanel() {
		
	}
	private void pobierz_dane_z_monitora(Monitor m) {
		this.liczba_ramek = m.zwroc_liczbe_ramek();
		this.liczba_stanow_potwierdzenia = m.zwroc_liczbe_stanow_potwierdzenia();
		this.liczba_stanow_przedalarmowych = m.zwroc_liczbe_stanow_przedalarmowych();
		if (this.czy_sdh == true) {
			this.liczba_bajtow_synchronizacyjnach = m.zwroc_liczbe_bajtow_synchronizacyjnych();
		}
		this.ber = m.zwroc_ber();
		this.dane_losowe = m.zwroc_dane_losowe();
		this.start_od_synchronizacji = m.zwroc_start_od_synchronizacji();
		if (this.czy_sdh == false) {
			this.wzor_symulowany = m.zwroc_wzor_symulowany();
		}
	}
	
	private void init() {
		this.setLayout(new GridLayout(7,2));
		JLabel text = new JLabel("Liczba ramek testowych:", JLabel.RIGHT);
		this.add(text);
		text = new JLabel(new Integer(this.liczba_ramek).toString(), JLabel.CENTER);
		this.add(text);
		
		text = new JLabel("BER:", JLabel.RIGHT);
		this.add(text);
		text = new JLabel(new Double(this.ber).toString(), JLabel.CENTER);
		this.add(text);
		
		text = new JLabel("Liczba stanw przedalarmowych:", JLabel.RIGHT);
		this.add(text);
		text = new JLabel(new Integer(this.liczba_stanow_przedalarmowych).toString(), JLabel.CENTER);
		this.add(text);
		
		text = new JLabel("Liczba stanw potwierdzenia:", JLabel.RIGHT);
		this.add(text);
		text = new JLabel(new Integer(this.liczba_stanow_potwierdzenia).toString(), JLabel.CENTER);
		this.add(text);
		
		if(this.czy_sdh == true) {
			text = new JLabel("Liczba bajtw synchroniazacji:", JLabel.RIGHT);
			this.add(text);
			text = new JLabel(new Short(this.liczba_bajtow_synchronizacyjnach).toString(), JLabel.CENTER);
			this.add(text);
		}
			
		text = new JLabel("Start badania od:", JLabel.RIGHT);
		this.add(text);
		if (this.start_od_synchronizacji==true) {
			text = new JLabel("stanu Synchronizacji", JLabel.CENTER);
			this.add(text);
		}
		else {
			text = new JLabel("stanu Poszukiwania", JLabel.CENTER);
			this.add(text);
		}
				
		text = new JLabel("Dane uytkownika s:", JLabel.RIGHT);
		this.add(text);
		if (this.dane_losowe == true) {
			text = new JLabel("losowe", JLabel.CENTER);
			this.add(text);
		}
		else {
			text = new JLabel("nielosowe", JLabel.CENTER);
			this.add(text);
		}
		if (this.czy_sdh == false) {
			text = new JLabel("Wzr fazowania jest:", JLabel.RIGHT);
			this.add(text);
			if (this.wzor_symulowany == true) {
				text = new JLabel("symulowany", JLabel.CENTER);
				this.add(text);
			}
			else {
				text = new JLabel("nie symulowany", JLabel.CENTER);
				this.add(text);
			}
		}
		
		
	}
	public void organizuj() {
		this.init();
	}
	public void wstaw_liczbe_ramek(int liczba) {
		this.liczba_ramek = liczba;
	}
	public void wstaw_liczbe_stanow_potwierdzenia(int liczba) {
		this.liczba_stanow_potwierdzenia = liczba;
	}
	public void wstaw_liczbe_stanow_przedalarmowych(int liczba) {
		this.liczba_stanow_przedalarmowych = liczba;
	}
	public void wstaw_ber(double ber) {
		this.ber = ber;
	}
	public void wstaw_start_synchronizacji(boolean start) {
		this.start_od_synchronizacji = start;
	}
	public void wstaw_dane_losowe(boolean dane) {
		this.dane_losowe = dane;
	}
	public void wstaw_wzor_symulowany(boolean decyzja) {
		this.wzor_symulowany = decyzja;
	}
	public void wstaw_liczbe_bajtow_synchronizacyjnych(short liczba) {
		this.liczba_bajtow_synchronizacyjnach = liczba;
	}
	public void wprowadzam_dane_sdh() {
		this.czy_sdh = true;
	}
	public void wprowadzam_dane_pcm() {
		this.czy_sdh = false;
	}
}
